/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.recipes.eda;

import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SerializedRecipe;
import com.dataiku.dip.dataflow.JobActivity;
import com.dataiku.dip.dataflow.RecipeRunnableSubgraph;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.eda.worksheets.cards.Card;
import com.dataiku.dip.eda.worksheets.cards.UnivariateCard;
import com.dataiku.dip.eda.worksheets.cards.common.ColumnCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.QuantilesTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateFrequencyTableCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateHeaderCard;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateSummaryStatsBuilder;
import com.dataiku.dip.eda.worksheets.cards.univariate_header.UnivariateSummaryStatsCard;
import com.dataiku.dip.recipes.RecipeMeta;
import com.dataiku.dip.recipes.RecipeParams;
import com.dataiku.dip.recipes.common.SISORecipeCreator;
import com.dataiku.dip.recipes.eda.EDARecipeParams;
import com.dataiku.dip.recipes.eda.UnivariateRecipePayloadParams;
import com.dataiku.dip.recipes.eda.UnivariateRecipeSchemaComputer;
import com.dataiku.dip.recipes.eda.univariate.UnivariateAnalysisWrapper;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NullChecker;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class UnivariateRecipeCreator
extends SISORecipeCreator {
    public UnivariateRecipeCreator(AuthCtx authCtx, RecipeMeta meta) {
        super(authCtx, meta);
    }

    @Override
    protected RecipeParams makeInitialParams(SerializedRecipe sr, JsonObject creationData) throws Exception {
        String originWorksheetId = null;
        if (creationData.has("originWorksheetId")) {
            JsonElement originWorksheetIdJson = creationData.get("originWorksheetId");
            originWorksheetId = originWorksheetIdJson.getAsString();
        }
        StreamableDatasetSelection datasetSelection = StreamableDatasetSelection.full();
        if (creationData.has("datasetSelection")) {
            JsonObject selectionJson = creationData.getAsJsonObject("datasetSelection");
            datasetSelection = (StreamableDatasetSelection)((Object)JSON.parse((JsonElement)selectionJson, StreamableDatasetSelection.class));
        }
        ContainerExecSelection containerSelection = new ContainerExecSelection();
        if (creationData.has("containerSelection")) {
            JsonObject selectionJson = creationData.getAsJsonObject("containerSelection");
            containerSelection = (ContainerExecSelection)JSON.parse((JsonElement)selectionJson, ContainerExecSelection.class);
        }
        EDARecipeParams params = new EDARecipeParams(originWorksheetId, datasetSelection, containerSelection);
        NullChecker.checkObject((Object)params);
        return params;
    }

    @Override
    protected String makeInitialPayload(SerializedRecipe recipe, Dataset inputDataset, Dataset outputDataset, JsonObject data) {
        boolean useDefaultParameters;
        JsonElement flag = data.get("useDefaultParameters");
        boolean bl = useDefaultParameters = flag != null && flag.getAsBoolean();
        if (useDefaultParameters) {
            UnivariateRecipePayloadParams initialPayload = new UnivariateRecipePayloadParams();
            return JSON.json((Object)initialPayload);
        }
        JsonObject cardJson = data.getAsJsonObject("card");
        UnivariateHeaderCard headerCard = (UnivariateHeaderCard)JSON.parse((JsonElement)cardJson, UnivariateHeaderCard.class);
        NullChecker.checkObject((Object)headerCard);
        boolean withConfidenceIntervals = false;
        if (data.has("withConfidenceIntervals")) {
            withConfidenceIntervals = data.get("withConfidenceIntervals").getAsBoolean();
        }
        double confidenceLevel = 0.95;
        if (data.has("confidenceLevel") && withConfidenceIntervals) {
            confidenceLevel = data.get("confidenceLevel").getAsDouble();
        }
        UnivariateRecipePayloadParams initialPayload = new UnivariateRecipePayloadParams(headerCard.showSummary, headerCard.showFrequencyTable, headerCard.showQuantile, withConfidenceIntervals, confidenceLevel, headerCard.splitBy);
        for (Card columnCard : headerCard.cards) {
            if (!(columnCard instanceof ColumnCard)) {
                throw new IllegalArgumentException(String.format("Expected a column card but got '%s' instead", ((Object)((Object)columnCard)).getClass().getSimpleName()));
            }
            ColumnCard colCard = (ColumnCard)columnCard;
            UnivariateAnalysisWrapper analysis = new UnivariateAnalysisWrapper(colCard.column);
            for (Card card : colCard.cards) {
                UnivariateCard testCard;
                if (card instanceof UnivariateSummaryStatsCard) {
                    testCard = (UnivariateSummaryStatsCard)card;
                    if (colCard.column.isContinuous()) {
                        analysis.summaryStats.compute = ((UnivariateSummaryStatsBuilder.StatsToCompute)JSON.deepCopy((Object)testCard.compute)).forContinuous();
                        continue;
                    }
                    analysis.summaryStats.compute = ((UnivariateSummaryStatsBuilder.StatsToCompute)JSON.deepCopy((Object)testCard.compute)).forCategorical();
                    continue;
                }
                if (card instanceof UnivariateFrequencyTableCard) {
                    testCard = (UnivariateFrequencyTableCard)card;
                    analysis.frequencyTable.maxValues = ((UnivariateFrequencyTableCard)testCard).maxValues;
                    continue;
                }
                if (!(card instanceof QuantilesTableCard)) continue;
                testCard = (QuantilesTableCard)card;
                analysis.quantileTable.customFreqs = ((QuantilesTableCard)testCard).customFreqs;
            }
            initialPayload.analyses.add(analysis);
        }
        NullChecker.checkObject((Object)initialPayload);
        return JSON.json((Object)initialPayload);
    }

    @Override
    protected void setOutputSchema(SerializedRecipe recipe, String payload, Dataset outputDataset) throws Exception {
        FlowRecipe fr = new FlowRecipe(recipe);
        RecipeRunnableSubgraph subgraph = this.recipesValidationService.getSampleSubgraph(fr);
        JobActivity activity = new JobActivity(subgraph);
        UnivariateRecipeSchemaComputer schemaComputer = new UnivariateRecipeSchemaComputer(this.authCtx, activity);
        schemaComputer.setPayload(payload);
        Schema schema = schemaComputer.getOutputSchema();
        outputDataset.setSchema(schema);
    }
}

