/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.scheduler.runnables;

import com.dataiku.dip.CodedRuntimeException;
import com.dataiku.dip.autoconfig.ParamDesc;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.plugins.IPluginsRegistryService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageContext;
import com.dataiku.dip.resourceusage.CurrentComputeResourceUsageContext;
import com.dataiku.dip.scheduler.reports.ReportTargetItem;
import com.dataiku.dip.scheduler.runnables.CustomJavaRunnablesService;
import com.dataiku.dip.scheduler.runnables.CustomPythonRunnablesService;
import com.dataiku.dip.scheduler.runnables.DSSRunnableDesc;
import com.dataiku.dip.scheduler.runnables.DSSRunnableMeta;
import com.dataiku.dip.scheduler.runnables.DSSRunnableRegistry;
import com.dataiku.dip.scheduler.runnables.DSSRunnableResult;
import com.dataiku.dip.scheduler.runnables.DSSRunnableThread;
import com.dataiku.dip.scheduler.runnables.LoadedJavaRunnable;
import com.dataiku.dip.scheduler.runnables.LoadedPythonRunnable;
import com.dataiku.dip.scheduler.runnables.LoadedRunnable;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.tickets.APITicketService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSRunnablesService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private CustomPythonRunnablesService customPythonRunnablesService;
    @Autowired
    private CustomJavaRunnablesService customJavaRunnablesService;
    @Autowired
    private APITicketService apiTicketService;
    @Autowired
    private VariablesService variablesService;
    private static Logger logger = Logger.getLogger((String)"dip.runnables.controller");

    public FutureResponse<DSSRunnableResult> run(String runnableType, AuthCtx authCtx, @Nullable String projectKey, JsonObject params, JsonObject adminParams, File contextDir) throws Exception {
        if (adminParams != null && authCtx.isAdmin()) {
            logger.info((Object)"Flush admin parameters into the parameters");
            for (Map.Entry param : adminParams.entrySet()) {
                params.add((String)param.getKey(), (JsonElement)param.getValue());
            }
        }
        VariablesContext variablesContext = StringUtils.isNotBlank((String)projectKey) ? this.variablesService.getForProject(projectKey) : this.variablesService.getForGlobal();
        DSSRunnableMeta meta = DSSRunnableRegistry.getMeta(runnableType);
        for (ParamDesc param : meta.getParams()) {
            if (!params.has(param.name) || param.type != ParamDesc.Type.CLUSTER) continue;
            params.addProperty(param.name, variablesContext.expandAllowUnresolved(params.get(param.name).getAsString()));
        }
        for (ParamDesc param : meta.getParams()) {
            if (!params.has(param.name) || param.type != ParamDesc.Type.CLUSTER || param.clusterPermissions == null) continue;
            String clusterId = params.get(param.name).getAsString();
            logger.info((Object)("Checking permissions for user " + String.valueOf(authCtx) + " on param " + param.name + "=" + clusterId));
            for (Privileges.ClusterLevelPrivilegeType permission : param.clusterPermissions) {
                this.permissionsService.checkClusterPrivileges(authCtx, clusterId, permission);
            }
        }
        DSSRunnableThread ft = new DSSRunnableThread(authCtx, runnableType, params, projectKey, contextDir, this.apiTicketService, this.futureService);
        FutureResponse<DSSRunnableResult> fr = this.futureService.runFuture(ft, 200L, new TypeToken<FutureResponse<DSSRunnableResult>>(){});
        return fr;
    }

    public LoadedRunnable<?> getRunnableOrNull(String runnableType) {
        LoadedRunnable runnable = null;
        for (LoadedPythonRunnable pythonRunnable : this.customPythonRunnablesService.list()) {
            if (!pythonRunnable.runnableType.equals(runnableType)) continue;
            runnable = pythonRunnable;
        }
        for (LoadedJavaRunnable javaRunnable : this.customJavaRunnablesService.list()) {
            if (!javaRunnable.runnableType.equals(runnableType)) continue;
            runnable = javaRunnable;
        }
        return runnable;
    }

    public LoadedRunnable<?> getRunnable(String runnableType) {
        LoadedRunnable<?> runnable = this.getRunnableOrNull(runnableType);
        if (runnable == null) {
            throw new CodedRuntimeException((InfoMessage.MessageCode)IPluginsRegistryService.PluginCodes.ERR_PLUGIN_COMPONENT_NOT_INSTALLED, "No macro of type " + runnableType);
        }
        return runnable;
    }

    public List<LoadedRunnable<?>> listRunnables() {
        ArrayList runnables = Lists.newArrayList();
        runnables.addAll(this.customPythonRunnablesService.list());
        runnables.addAll(this.customJavaRunnablesService.list());
        return runnables;
    }

    public boolean canRun(String runnableType, AuthCtx user, String projectKey) throws DKUSecurityException {
        return this.canRun(this.getRunnable(runnableType), user, projectKey);
    }

    public boolean canRun(LoadedRunnable<?> runnable, AuthCtx user, String projectKey) throws DKUSecurityException {
        if (((DSSRunnableDesc)runnable.desc).requiresGlobalAdmin) {
            return user.isAdmin();
        }
        if (((DSSRunnableDesc)runnable.desc).permissions != null) {
            boolean hasPermissions = true;
            for (Privileges.ProjectLevelPrivilegeType permission : ((DSSRunnableDesc)runnable.desc).permissions) {
                boolean required = this.permissionsService.hasProjectPrivilege(user, projectKey, permission);
                hasPermissions &= required;
            }
            return hasPermissions;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonObject runMacroFunction(AuthCtx authCtx, String projectKey, File tmpDir, String runnableType, JsonObject config, String inputJson) throws IOException, DKUSecurityException, Exception {
        FutureResponse fr;
        long started;
        LoadedRunnable<?> runnable = this.getRunnable(runnableType);
        File contextDir = new File(tmpDir, "macro-function");
        DKUFileUtils.mkdirs((File)contextDir);
        for (DSSRunnableDesc.MacroRoleDef role : ((DSSRunnableDesc)runnable.desc).macroRoles) {
            if (role.type != DSSRunnableDesc.MacroRoleDef.Type.FUNCTION) continue;
            config.addProperty(role.targetParamsKey, inputJson);
        }
        try (Transaction t = ((TransactionService)SpringUtils.getBean(TransactionService.class)).beginRead();){
            if (!this.canRun(runnableType, authCtx, projectKey)) {
                throw new Exception("Not allowed to run macro function");
            }
            started = DateTime.now().getMillis();
            CurrentComputeResourceUsageContext.setInCurrentThread((ComputeResourceUsageContext)ComputeResourceUsageContext.forMacro((AuthCtx)authCtx, (String)runnableType, (String)projectKey, null, null, null));
            try {
                fr = this.run(runnableType, authCtx, projectKey, config, new JsonObject(), contextDir);
            }
            finally {
                CurrentComputeResourceUsageContext.clear();
            }
        }
        fr = ((FutureService)((Object)SpringUtils.getBean(FutureService.class))).waitForFinalResponse(fr);
        DSSRunnableResult result = (DSSRunnableResult)fr.result;
        long ended = DateTime.now().getMillis();
        logger.info((Object)("Function ran in " + (ended - started)));
        if (result.error != null) {
            throw new Exception("Failed to run function");
        }
        if (result.failure != null) {
            throw new Exception("Function run returned in error");
        }
        if (result.type != DSSRunnableResult.ResultType.JSON_OBJECT) {
            throw new Exception("Function didn't return a json object");
        }
        JsonObject outputJson = ((ReportTargetItem.JsonObjectItem)result.data).object;
        return outputJson;
    }
}

