/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.security.auth;

import com.dataiku.dip.dao.DkuUser;
import com.dataiku.dip.dao.UsersActivityDAO;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.DkuLoginEventService;
import com.dataiku.dip.server.notifications.backend.LoginEvent;
import com.dataiku.dip.server.notifications.backend.LogoutEvent;
import com.dataiku.dip.server.services.PubSubService;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSLoginEventService
implements DkuLoginEventService {
    private final AuditTrailService auditTrailService;
    private final UsersActivityDAO usersActivityDAO;
    private final PubSubService pubSubService;

    @Autowired
    public DSSLoginEventService(AuditTrailService auditTrailService, UsersActivityDAO usersActivityDAO, PubSubService pubSubService) {
        this.auditTrailService = auditTrailService;
        this.usersActivityDAO = usersActivityDAO;
        this.pubSubService = pubSubService;
    }

    public void onLoginError(String dkuUserLoginCandidate) {
        this.usersActivityDAO.updateUserLastLogin(dkuUserLoginCandidate, Boolean.valueOf(false));
        this.auditTrailService.generic("login-failure").with("login", dkuUserLoginCandidate).emit();
    }

    public void onPasswordBasedLoginSuccess(HttpServletRequest req, DkuUser dkuUser) throws Exception {
        this.onLoginSuccess(dkuUser);
    }

    public void onSSOLoginSuccess(DkuUser dkuUser) {
        this.onLoginSuccess(dkuUser);
    }

    private void onLoginSuccess(DkuUser dkuUser) {
        this.usersActivityDAO.updateUserLastLogin(dkuUser.getLogin(), Boolean.valueOf(true));
        this.pubSubService.publish(LoginEvent.withUsername(dkuUser.getLogin(), dkuUser.getDisplayName()));
        this.auditTrailService.generic("login-success").with("login", dkuUser.getLogin()).emit();
    }

    public void onNoLoginLoginSuccess(DkuUser dkuUser) {
        this.auditTrailService.generic("login-success").with("login", dkuUser.getLogin()).emit();
    }

    public void onLogout(AuthCtx user) {
        this.pubSubService.publish(LogoutEvent.withUsername(user.getIdentifier(), user.getUserEmail()));
    }
}

