/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.dao.impl.FlowStateInternalDB;
import com.dataiku.dip.dataflow.ComputableHashComputer;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.db.DSSDBConnection;
import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.futures.DSSFuturePayloadUtils;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.metrics.Metric;
import com.dataiku.dip.metrics.MetricCodes;
import com.dataiku.dip.metrics.MetricTargetType;
import com.dataiku.dip.metrics.MetricsComputationService;
import com.dataiku.dip.metrics.MetricsEngineDesc;
import com.dataiku.dip.metrics.MetricsLaunchService;
import com.dataiku.dip.metrics.MetricsService;
import com.dataiku.dip.metrics.Model;
import com.dataiku.dip.metrics.ProbesSet;
import com.dataiku.dip.metrics.probes.BasicProbeType;
import com.dataiku.dip.metrics.probes.PartitioningProbeType;
import com.dataiku.dip.metrics.probes.Probe;
import com.dataiku.dip.metrics.probes.RecordsProbeType;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitionFactory;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.datasets.DatasetsCRUDController;
import com.dataiku.dip.server.services.ReadOnlyJobsInternalDB;
import com.dataiku.dip.shaker.types.LongMeaning;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DatasetMetricsStatusService {
    @Autowired
    private FutureService futureService;
    @Autowired
    private MetricsComputationService metricsComputationService;
    @Autowired
    private MetricsLaunchService metricsLaunchService;
    @Autowired
    private MetricsService metricsService;
    @Autowired
    private ReadOnlyJobsInternalDB jobsDatabaseAccessService;
    @Autowired
    private FlowStateInternalDB flowStateInternalDB;
    private LongMeaning longMeaning = new LongMeaning();
    private static DKULogger logger = DKULogger.getLogger((String)"dku.datasets.status.service");

    public DatasetSummaryStatus getCachedSummaryStatus(Dataset dataset) throws Exception {
        logger.traceV("getCachedSummaryStatus dataset=%s", new Object[]{dataset.getFullName()});
        CachedPartitionsList partitionsList = this.getCachedPartitionsList(dataset);
        logger.traceV("getCachedSummaryStatus dataset=%s nb_partitions=%d", new Object[]{dataset.getFullName(), partitionsList.partitionIds.size()});
        DatasetSummaryStatus ret = new DatasetSummaryStatus();
        ret.size = this.getCachedValues(dataset, new BasicProbeType.BasicMetric(BasicProbeType.BasicMetrics.SIZE), partitionsList, false);
        ret.records = this.getCachedValues(dataset, new RecordsProbeType.RecordsMetric(RecordsProbeType.RecordsMetrics.COUNT_RECORDS), partitionsList, false);
        ret.partitions = partitionsList.partitionIds.size();
        ret.partitionsLastCompute = partitionsList.lastCompute;
        logger.traceV("getCachedSummaryStatus done dataset=%s", new Object[]{dataset.getFullName()});
        return ret;
    }

    public FutureResponse<DatasetSummaryStatusWithMessages> refreshSummary_F(AuthCtx user, Dataset dataset, boolean includeRecordCount, boolean forceRecompute) throws Exception {
        UpdateValuesThread thread = this.prepareRefreshSummary(user, dataset, includeRecordCount, forceRecompute);
        return this.futureService.runFuture(thread, 100L, new TypeToken<FutureResponse<DatasetSummaryStatusWithMessages>>(){});
    }

    private CachedPartitionsList getCachedPartitionsList(Dataset dataset) throws Exception, SQLException {
        DatasetLocUtils.DatasetLoc loc = dataset.getLoc();
        CachedPartitionsList ret = new CachedPartitionsList();
        if (dataset.getPartitioningSchema().isPartitioned()) {
            List<ReadOnlyJobsInternalDB.MetricDataPoint> partitionList = this.jobsDatabaseAccessService.getLastMetricValues(loc, new PartitioningProbeType.PartitioningMetric(PartitioningProbeType.PartitioningMetrics.PARTITIONS_LIST).getId());
            for (ReadOnlyJobsInternalDB.MetricDataPoint point : partitionList) {
                if (!point.partition.equals("ALL") && !point.partition.equals("NP")) continue;
                ret.lastCompute = point.time;
                try {
                    ret.partitionIds.addAll((Collection)JSON.parse((String)point.value, (TypeToken)new TypeToken<List<String>>(){}));
                }
                catch (Exception exception) {}
            }
        } else {
            ret.partitionIds.add("NP");
            ret.lastCompute = System.currentTimeMillis();
        }
        return ret;
    }

    public FutureResponse<InfoMessage.InfoMessages> refreshMultiSummaries_F(AuthCtx user, List<Dataset> datasets, boolean includeRecordCount, boolean forceRecompute) throws Exception {
        ArrayList<UpdateValuesThread> threads = new ArrayList<UpdateValuesThread>();
        for (Dataset dataset : datasets) {
            threads.add(this.prepareRefreshSummary(user, dataset, includeRecordCount, forceRecompute));
        }
        MultiUpdateValuesThread muvt = new MultiUpdateValuesThread(user, threads);
        return this.futureService.runFuture(muvt, 100L, new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    private UpdateValuesThread prepareRefreshSummary(AuthCtx user, Dataset dataset, boolean includeRecordCount, boolean forceRecompute) throws IOException {
        ProbesSet metrics = new ProbesSet();
        Probe partitioningProbe = new Probe("partitioning");
        Probe basicProbe = new Probe("basic");
        Probe recordsProbe = new Probe("records");
        metrics.probes.add(partitioningProbe);
        metrics.probes.add(basicProbe);
        metrics.probes.add(recordsProbe);
        PartitioningProbeType.PartitioningProbeConfiguration partitioningProbeConfiguration = new PartitioningProbeType.PartitioningProbeConfiguration();
        BasicProbeType.BasicProbeConfiguration basicProbeConfiguration = new BasicProbeType.BasicProbeConfiguration();
        RecordsProbeType.RecordsProbeConfiguration recordsProbeConfiguration = new RecordsProbeType.RecordsProbeConfiguration();
        partitioningProbe.withConfiguration(partitioningProbeConfiguration).withEnabled(true);
        basicProbe.withConfiguration(basicProbeConfiguration).withEnabled(true);
        recordsProbe.withConfiguration(recordsProbeConfiguration).withEnabled(includeRecordCount);
        MetricsComputationService.MetricsComputationEnvironment environment = new MetricsComputationService.MetricsComputationEnvironment();
        environment.startedFromBuild = false;
        GeneralSettingsDAO.GeneralSettings generalSettings = ApplicationConfigurator.getGeneralSettings();
        environment.graphiteServerUrl = generalSettings.graphiteServerUrl;
        environment.graphiteMetricPrefix = generalSettings.graphiteMetricPrefix;
        DatasetHandler handler = DatasetHandlerFactory.build(user, dataset);
        Metric stalenessReference = includeRecordCount ? new RecordsProbeType.RecordsMetric(RecordsProbeType.RecordsMetrics.COUNT_RECORDS) : new BasicProbeType.BasicMetric(BasicProbeType.BasicMetrics.SIZE);
        return new UpdateValuesThread(user, dataset, forceRecompute, handler, metrics, environment, stalenessReference);
    }

    private Model.SummedDatasetMetricValue getCachedValues(Dataset dataset, Metric metric, CachedPartitionsList partitionsList, boolean withDetails) throws Exception {
        DatasetLocUtils.DatasetLoc loc = dataset.getLoc();
        Model.SummedDatasetMetricValue ret = withDetails ? new Model.DetailedSummedDatasetMetricValue() : new Model.SummedDatasetMetricValue();
        List<ReadOnlyJobsInternalDB.MetricDataPoint> values = this.jobsDatabaseAccessService.getLastMetricValues(loc, metric.getId());
        long totalValue = 0L;
        HashMap partitionValues = Maps.newHashMap();
        boolean hasData = false;
        for (ReadOnlyJobsInternalDB.MetricDataPoint point : values) {
            if (point.partition.equals("ALL") || !partitionsList.partitionIds.contains(point.partition)) continue;
            ret.updateTimeRange(point.time);
            try {
                long partitionValue = this.longMeaning.permissiveLongValue(point.value);
                partitionValues.put(point.partition, partitionValue);
                totalValue += partitionValue;
                hasData = true;
            }
            catch (Exception ex) {
                logger.warn((Object)("Metric value " + point.value + " is not a record count. Ignoring partition " + point.partition));
            }
        }
        boolean hasMissing = false;
        for (String partitionId : partitionsList.partitionIds) {
            if (partitionId.equals("ALL")) continue;
            Long partitionValue = (Long)partitionValues.get(partitionId);
            if (partitionValue == null) {
                hasMissing = true;
                if (!withDetails) continue;
                ((Model.DetailedSummedDatasetMetricValue)ret).partitions.add(new Model.LongMetricPartitionValue(partitionId, -1L));
                continue;
            }
            if (!withDetails) continue;
            ((Model.DetailedSummedDatasetMetricValue)ret).partitions.add(new Model.LongMetricPartitionValue(partitionId, partitionValue));
        }
        ret.totalValue = hasData ? totalValue : -1L;
        ret.incomplete = hasMissing;
        ret.hasData = hasData;
        return ret;
    }

    public static FuturePayload buildFuturePayload(Dataset dataset) {
        FuturePayload fp = new FuturePayload();
        fp.action = "dataset_status_update";
        fp.targets.add(DSSFuturePayloadUtils.forDataset(dataset).withPart("status"));
        fp.displayName = "Updating dataset summary status on partitions of " + dataset.getFullName();
        return fp;
    }

    public void addSizeAndRecordsToDatasets(List<DatasetsCRUDController.DatasetListItem> datasets) throws Exception {
        Map<AnyLoc, List<ReadOnlyJobsInternalDB.MetricDataPoint>> datasetMapMetrics = this.jobsDatabaseAccessService.readAllLastProjectMetrics(Lists.newArrayList((Object[])new String[]{"records:COUNT_RECORDS", "basic:SIZE"}), datasets.stream().map(d -> new AnyLoc(d.projectKey, d.id)).toList());
        for (DatasetsCRUDController.DatasetListItem item : datasets) {
            for (ReadOnlyJobsInternalDB.MetricDataPoint mdp : datasetMapMetrics.getOrDefault(new AnyLoc(item.projectKey, item.id), Collections.emptyList())) {
                if (mdp.metric.id.equals("basic:SIZE")) {
                    item.status.size = new Model.SummedDatasetMetricValue();
                    item.status.size.lastComputed = mdp.time;
                    item.status.size.totalValue = Long.parseLong(mdp.value);
                    continue;
                }
                if (!mdp.metric.id.equals("records:COUNT_RECORDS")) continue;
                item.status.records = new Model.SummedDatasetMetricValue();
                item.status.records.lastComputed = mdp.time;
                item.status.records.totalValue = Long.parseLong(mdp.value);
            }
        }
    }

    public static FuturePayload buildFuturePayload(List<UpdateValuesThread> tasks) {
        FuturePayload fp = new FuturePayload();
        fp.action = "dataset_status_update";
        for (UpdateValuesThread task : tasks) {
            fp.targets.addAll(task.getPayload().targets);
        }
        fp.displayName = "Updating multiple dataset summary status";
        return fp;
    }

    private static class CachedPartitionsList {
        long lastCompute = 0L;
        Set<String> partitionIds = new HashSet<String>();

        private CachedPartitionsList() {
        }
    }

    public static class DatasetSummaryStatus {
        public Model.SummedDatasetMetricValue size;
        public Model.SummedDatasetMetricValue records;
        public long partitionsLastCompute;
        public int partitions;
    }

    private class UpdateValuesThread
    extends SimpleFutureThread<DatasetSummaryStatusWithMessages> {
        private Dataset dataset;
        private boolean forceRecompute;
        private ProbesSet metrics;
        private MetricsComputationService.MetricsComputationEnvironment environment;
        private DatasetHandler handler;
        private Metric stalenessReference;
        private FuturePayload futurePayload;

        public UpdateValuesThread(AuthCtx user, Dataset dataset, boolean forceRecompute, DatasetHandler handler, ProbesSet metrics, MetricsComputationService.MetricsComputationEnvironment environment, Metric stalenessReference) {
            super(user);
            this.dataset = dataset;
            this.forceRecompute = forceRecompute;
            this.handler = handler;
            this.metrics = metrics;
            this.environment = environment;
            this.stalenessReference = stalenessReference;
            this.futurePayload = DatasetMetricsStatusService.buildFuturePayload(dataset);
        }

        @Override
        protected DatasetSummaryStatusWithMessages compute() throws Exception {
            try {
                DatasetSummaryStatusWithMessages datasetSummaryStatusWithMessages = this.doCompute();
                return datasetSummaryStatusWithMessages;
            }
            finally {
                this.handler.close();
            }
        }

        private DatasetSummaryStatusWithMessages doCompute() throws Exception {
            PartitioningScheme partitioningScheme = this.dataset.getPartitioningSchema();
            Partition wholeDatasetPartition = partitioningScheme != null && partitioningScheme.isPartitioned() ? Partition.newALL((PartitioningScheme)partitioningScheme) : Partition.newNP();
            ArrayList probesAsBefore = Lists.newArrayList(this.metrics.probes);
            ArrayList probesForPartitioning = Lists.newArrayList();
            ArrayList probesForRest = Lists.newArrayList();
            for (Probe probe : this.metrics.probes) {
                if (probe.getType().equals("partitioning")) {
                    probesForPartitioning.add(probe);
                    continue;
                }
                probesForRest.add(probe);
            }
            try {
                DatasetSummaryStatusWithMessages datasetSummaryStatusWithMessages;
                block47: {
                    FutureProgress.AutocloseableFutureProgressState afp = FutureProgress.pushAutoCloseableState((String)("Updating status of " + this.dataset.getName()), (double)10.0, (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);
                    try {
                        ArrayList stale;
                        block45: {
                            List<Partition> partitions = null;
                            try (FutureProgress.AutocloseableFutureProgressState afp2 = FutureProgress.pushAutoCloseableState((String)"Enumerating partitions");){
                                logger.info((Object)"Start recomputation starting, listing partitions");
                                partitions = this.handler.listPartitions();
                            }
                            catch (DataStoreIOException e) {
                                DatasetMetricsStatusService.this.metricsService.clearMetrics(this.dataset, "");
                                logger.warnV("Clearing metrics for dataset %s as associated file not found", new Object[]{this.dataset.getName()});
                                throw e;
                            }
                            FutureProgress.getState().set(2.0);
                            logger.info((Object)("Got partitions " + partitions.size()));
                            this.metrics.probes = probesForPartitioning;
                            MetricsEngineDesc.MetricsEngineContext context = new MetricsEngineDesc.MetricsEngineContext(this.owner);
                            context.partitions = partitions;
                            DatasetMetricsStatusService.this.metricsComputationService.computeMetrics(this.owner, this.dataset, MetricTargetType.DATASET, wholeDatasetPartition, this.metrics, context, this.environment);
                            logger.info((Object)"Updated list of partitions metric. For safety, getting it back");
                            logger.info((Object)JSON.json(DatasetMetricsStatusService.this.jobsDatabaseAccessService.getLastMetricValues(this.dataset.getLoc(), new PartitioningProbeType.PartitioningMetric(PartitioningProbeType.PartitioningMetrics.PARTITIONS_LIST).getId())));
                            stale = Lists.newArrayList();
                            try (FutureProgress.AutocloseableFutureProgressState afp2 = FutureProgress.pushAutoCloseableState((String)"Checking partitions status");){
                                HashSet partitionIds = Sets.newHashSet();
                                for (Partition partition : partitions) {
                                    partitionIds.add(partition.id());
                                }
                                if (this.forceRecompute) {
                                    stale.addAll(partitionIds);
                                    break block45;
                                }
                                DatasetLocUtils.DatasetLoc loc = this.dataset.getLoc();
                                List<ReadOnlyJobsInternalDB.MetricDataPoint> stalenessPoints = DatasetMetricsStatusService.this.jobsDatabaseAccessService.getLastMetricValues(loc, this.stalenessReference.getId());
                                HashMap partitionHashes = Maps.newHashMap();
                                for (ReadOnlyJobsInternalDB.MetricDataPoint point : stalenessPoints) {
                                    partitionHashes.put(point.partition, point.hash);
                                }
                                ComputableHashComputer hashComputer = new ComputableHashComputer(this.owner);
                                try (DSSDBConnection conn = DatasetMetricsStatusService.this.flowStateInternalDB.acquireConnection();){
                                    for (String partition : partitionIds) {
                                        if ("ALL".equals(partition)) continue;
                                        if (partitionHashes.containsKey(partition)) {
                                            String hash = hashComputer.getCurrentContentHash((DSSDBConnection)conn, (Dataset)this.dataset, (Partition)PartitionFactory.fromIdentifier((PartitioningScheme)partitioningScheme, (String)partition)).hash;
                                            if (hash.equals(partitionHashes.get(partition))) continue;
                                            stale.add(partition);
                                            continue;
                                        }
                                        stale.add(partition);
                                    }
                                }
                            }
                        }
                        FutureProgress.getState().set(4.0);
                        logger.info((Object)("Found " + stale.size() + " stale partitions, recomputing their record counts: " + Joiner.on((String)", ").join((Iterable)stale)));
                        FutureResponse computationFuture = null;
                        this.metrics.probes = probesForRest;
                        try (FutureProgress.AutocloseableFutureProgressState afp2 = FutureProgress.pushAutoCloseableState((String)"Updating partitions status");){
                            computationFuture = DatasetMetricsStatusService.this.metricsLaunchService.launchComputeMetricsWithExplicitPartitionIds(this.owner, this.dataset, stale, this.metrics, this.environment);
                            computationFuture = DatasetMetricsStatusService.this.futureService.waitForFinalResponse(computationFuture);
                        }
                        String json = JSON.json((Object)DatasetMetricsStatusService.this.getCachedSummaryStatus(this.dataset));
                        DatasetSummaryStatusWithMessages ret = (DatasetSummaryStatusWithMessages)JSON.parse((String)json, DatasetSummaryStatusWithMessages.class);
                        if (computationFuture.result != null) {
                            for (MetricsComputationService.MetricsComputationReport report : ((MetricsComputationService.MetricsComputationReports)computationFuture.result).reports) {
                                report.toInfoMessages(ret.messages);
                            }
                        }
                        datasetSummaryStatusWithMessages = ret;
                        if (afp == null) break block47;
                    }
                    catch (Throwable throwable) {
                        if (afp != null) {
                            try {
                                afp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    afp.close();
                }
                return datasetSummaryStatusWithMessages;
            }
            finally {
                this.metrics.probes = probesAsBefore;
            }
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    private class MultiUpdateValuesThread
    extends SimpleFutureThread<InfoMessage.InfoMessages> {
        private final List<UpdateValuesThread> tasks;
        private final FuturePayload futurePayload;

        public MultiUpdateValuesThread(AuthCtx user, List<UpdateValuesThread> tasks) {
            super(user);
            this.tasks = tasks;
            this.futurePayload = DatasetMetricsStatusService.buildFuturePayload(tasks);
        }

        @Override
        protected InfoMessage.InfoMessages compute() throws Exception {
            InfoMessage.InfoMessages ret = new InfoMessage.InfoMessages();
            try (FutureProgress.AutocloseableFutureProgressState afp2 = FutureProgress.pushAutoCloseableState((String)"Updating status of datasets", (double)this.tasks.size(), (FutureProgressState.StateUnit)FutureProgressState.StateUnit.NONE);){
                int i = 0;
                for (UpdateValuesThread thread : this.tasks) {
                    try {
                        DatasetSummaryStatusWithMessages dsswm = thread.compute();
                        ret.mergeFrom(dsswm.messages);
                    }
                    catch (Exception e) {
                        logger.warn((Object)"One of the multi-compute failed", (Throwable)e);
                        ret.withFatal((InfoMessage.MessageCode)MetricCodes.ERR_METRIC_DATASET_COMPUTATION_FAILED, String.format("dataset:%s : %s", thread.dataset.getFullName(), ExceptionUtils.getMessageWithCauses((Throwable)e)));
                    }
                    FutureProgress.getState().set((double)(++i));
                }
            }
            return ret;
        }

        public FuturePayload getPayload() {
            return this.futurePayload;
        }
    }

    @UIModel
    public static class DatasetSummaryStatusWithMessages
    extends DatasetSummaryStatus {
        public InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
    }
}

