/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.datasets.fs.AbstractFSDatasetHandler;
import com.dataiku.dip.datasets.fs.BuiltinFSDatasets;
import com.dataiku.dip.datasets.fs.HDFSProvider;
import com.dataiku.dip.datasets.fs.LocalFSProvider;
import com.dataiku.dip.datasets.fs.UploadableDatasetConfig;
import com.dataiku.dip.datasets.fs.UploadedFilesDatasetHandler;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsSynchronizer;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.excel.ExcelFilesAnalyzer;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPath;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.fs.FSProvider;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.PathUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileUploadService {
    @Autowired
    DatasetsDAO datasetsDAO;
    static Set<String> weirdExtensions = new HashSet<String>();
    private static final Logger logger;

    private static String[] localDatasetPathElts(String projectKey, String datasetName) {
        return new String[]{"uploads", projectKey, "datasets", datasetName};
    }

    public static File localDatasetDir(String projectKey, String datasetName) {
        return ApplicationConfigurator.getFile((String[])FileUploadService.localDatasetPathElts(projectKey, datasetName));
    }

    public static File uploadBoxDir(String uploadBoxId) {
        return ApplicationConfigurator.getFile((String[])new String[]{"uploads", "tmp_upload_box", uploadBoxId});
    }

    public static File datasetOrUploadBoxDir(Dataset dataset) {
        if (((UploadableDatasetConfig)((Object)dataset.getParams())).getUploadBoxId() != null) {
            return FileUploadService.uploadBoxDir(dataset.getParamsAs(BuiltinFSDatasets.UploadedFilesConfig.class).uploadBoxId);
        }
        return FileUploadService.localDatasetDir(dataset.getProjectKey(), dataset.getName());
    }

    public String newUploadBox() throws IOException {
        String uploadBoxId = SecretKeyGenerator.getRandomSHA256();
        File uploadBoxDir = FileUploadService.uploadBoxDir(uploadBoxId);
        if (uploadBoxDir.isDirectory()) {
            throw new IOException("Statistically speaking, this should not happen ...: " + uploadBoxId);
        }
        DKUFileUtils.mkdirs((File)uploadBoxDir);
        return uploadBoxId;
    }

    public static void deleteUploadBox(String uploadBoxId) throws IOException {
        File uploadBoxDir = FileUploadService.uploadBoxDir(uploadBoxId);
        if (!uploadBoxDir.isDirectory()) {
            throw ErrorContext.iaef((String)"Upload box dir %s does not exist or is not a directory", (Object)uploadBoxId, (Object[])new Object[0]);
        }
        DKUFileUtils.forceDelete((File)uploadBoxDir);
    }

    public static void deleteFileFromUploadBox(String uploadBoxId, String path) throws IOException {
        File uploadBoxDir = FileUploadService.uploadBoxDir(uploadBoxId);
        if (!uploadBoxDir.isDirectory()) {
            throw ErrorContext.iaef((String)"Upload box dir %s does not exist or is not a directory", (Object)uploadBoxId, (Object[])new Object[0]);
        }
        File file = DKUFileUtils.getWithin((File)uploadBoxDir, (String[])new String[]{path});
        if (file.exists()) {
            DKUFileUtils.forceDelete((File)file);
        }
    }

    public UploadedFiles addFileToUploadBox(String uploadBoxId, InputStream is, String name) throws IOException, DKUSecurityException, CodedException, InterruptedException {
        File uploadBoxDir = FileUploadService.uploadBoxDir(uploadBoxId);
        if (!uploadBoxDir.isDirectory()) {
            throw ErrorContext.iaef((String)"Upload box dir %s does not exist or is not a directory", (Object)uploadBoxId, (Object[])new Object[0]);
        }
        try (LocalFSProvider target = LocalFSProvider.makeFSProviderOnRoot(uploadBoxDir.getAbsolutePath());){
            UploadedFiles uploadedFiles = this.handleAddFile(target, is, name, true);
            return uploadedFiles;
        }
    }

    private UploadedFiles handleAddFile(FSProvider target, InputStream is, String name, boolean splitExcelFilesBySheets) throws IOException, CodedException, DKUSecurityException, InterruptedException {
        UploadedFiles ret = new UploadedFiles();
        if (!name.toLowerCase(Locale.ROOT).endsWith(".zip")) {
            if (target.stat(name) != null) {
                throw new IOException("File " + name + " already exists and would be overwritten");
            }
            try (OutputStream os = target.write(name);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
            }
            FSPathOrDirectory uploaded = target.stat(name);
            logger.info((Object)("Uploaded a file of size " + uploaded.getSize()));
            ret.files.addAll(this.createUploadedFiles(target, name, uploaded.path(), uploaded.getSize(), splitExcelFilesBySheets));
        } else {
            ZipEntry ze;
            ZipInputStream zis = new ZipInputStream(is);
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().contains("../")) {
                    throw new IOException("Illegal ZipEntry: " + ze.getName());
                }
                if (ze.isDirectory() || ze.getName().contains("__MACOSX/") || ze.getName().contains(".DS_Store")) continue;
                if (target.stat(ze.getName()) != null) {
                    throw new IOException("File " + ze.getName() + " already exists, and would be overwritten by expansion of Zip file " + name);
                }
                try (OutputStream fos = target.write(ze.getName());){
                    IOUtils.copyLarge((InputStream)zis, (OutputStream)fos);
                }
                FSPathOrDirectory uploaded = target.stat(ze.getName());
                ret.files.addAll(this.createUploadedFiles(target, ze.getName(), uploaded.path(), uploaded.getSize(), splitExcelFilesBySheets));
            }
            ret.wasArchive = true;
            zis.close();
        }
        return ret;
    }

    private List<UploadedFile> createUploadedFiles(FSProvider target, String name, String path, long size, boolean splitExcelFilesBySheets) {
        if (splitExcelFilesBySheets && ExcelFilesAnalyzer.isExcelFileType(name)) {
            ArrayList<UploadedFile> arrayList;
            block10: {
                InputStream excelFileInputStream = target.read(name).decompressedStream();
                try {
                    ArrayList<UploadedFile> result = new ArrayList<UploadedFile>();
                    for (String sheetName : ExcelFilesAnalyzer.listSheetNames(excelFileInputStream, null)) {
                        result.add(new UploadedFile(path, name, sheetName, size));
                    }
                    arrayList = result;
                    if (excelFileInputStream == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (excelFileInputStream != null) {
                            try {
                                excelFileInputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        logger.info((Object)("Unable to list sheet names from file " + name + " in " + path), (Throwable)e);
                        return Arrays.asList(new UploadedFile(path, name, size));
                    }
                }
                excelFileInputStream.close();
            }
            return arrayList;
        }
        return Arrays.asList(new UploadedFile(path, name, size));
    }

    static boolean isWeird(String filename) {
        String extension = (String)DKUtils.lastElement((Object[])StringUtils.split((String)filename, (String)"."));
        if (weirdExtensions.contains(extension)) {
            return true;
        }
        return filename.startsWith("README");
    }

    static String filenameToMime(String filename) {
        if (filename.endsWith("csv")) {
            return "text/csv";
        }
        if (filename.endsWith("xls")) {
            return "application/vnd.ms-excel";
        }
        if (filename.endsWith("xlsx")) {
            return "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet";
        }
        if (filename.endsWith("txt")) {
            return "text/plain";
        }
        if (filename.endsWith("tsv")) {
            return "text/csv";
        }
        return "application/octet-stream";
    }

    public List<UploadedFile> listFilesInDataset(String projectKey, String datasetName) {
        ArrayList<UploadedFile> list = new ArrayList<UploadedFile>();
        File datasetDir = FileUploadService.localDatasetDir(projectKey, datasetName);
        if (!datasetDir.exists()) {
            datasetDir.mkdirs();
        }
        this.listRec(datasetDir, "", list);
        return list;
    }

    public List<UploadedFile> listFilesInDataset(UploadedFilesDatasetHandler dh) throws IOException, CodedException, DKUSecurityException {
        ArrayList<UploadedFile> list = new ArrayList<UploadedFile>();
        AbstractFSDatasetHandler.FSProviderAndPath providerAndPath = dh.getProviderInternal(null);
        FSEnumerationResult enumeration = providerAndPath.provider.enumerateRecursive("/", new FSEnumerationSettings());
        if (enumeration.isSuccessful() && enumeration.getPaths() != null) {
            for (FSPath path : enumeration.getPaths()) {
                list.add(new UploadedFile(path.path(), (String)PathUtils.splitBasename((String)path.path()).second, path.getSize()));
            }
        }
        return list;
    }

    private void listRec(File folder, String curPath, List<UploadedFile> list) {
        for (File f : folder.listFiles()) {
            if (f.isDirectory()) {
                this.listRec(f, curPath + "/" + f.getName(), list);
                continue;
            }
            list.add(new UploadedFile(curPath + "/" + f.getName(), f.getName(), f.length()));
        }
    }

    public UploadedFiles addFileToDataset(String projectKey, String datasetName, InputStream is, String name) throws IOException, CodedException, DKUSecurityException, InterruptedException {
        File datasetDir = FileUploadService.localDatasetDir(projectKey, datasetName);
        if (!datasetDir.isDirectory()) {
            datasetDir.mkdirs();
        }
        try (LocalFSProvider target = LocalFSProvider.makeFSProviderOnRoot(datasetDir.getAbsolutePath());){
            UploadedFiles uploadedFiles = this.handleAddFile(target, is, name, false);
            return uploadedFiles;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UploadedFiles addFileToDataset(AuthCtx authCtx, UploadedFilesDatasetHandler dh, InputStream is, String name) throws Exception {
        AbstractFSDatasetHandler.FSProviderAndPath dhFs = dh.buildOneProvider();
        try {
            UploadedFiles uploadedFiles = this.handleAddFile(dhFs.provider, is, name, false);
            return uploadedFiles;
        }
        finally {
            dhFs.provider.close();
            if (dhFs.provider instanceof HDFSProvider) {
                new HDFSPermissionsSynchronizer().setPermissionsOnDataset_NT(authCtx, dh.getDataset().getProjectKey(), dh.getDataset().serialize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFileFromDataset(UploadedFilesDatasetHandler dh, String name) throws IOException, CodedException, DKUSecurityException {
        AbstractFSDatasetHandler.FSProviderAndPath dhFs = dh.buildOneProvider();
        try {
            dhFs.provider.deleteRecursive(name);
        }
        finally {
            dhFs.provider.close();
        }
    }

    public void removeFileFromDataset(String projectKey, String datasetName, String name) throws IOException {
        File datasetDir = FileUploadService.localDatasetDir(projectKey, datasetName);
        if (!datasetDir.isDirectory()) {
            throw ErrorContext.iaef((String)"Dataset dir %s does not exist or is not a directory", (Object)datasetName, (Object[])new Object[0]);
        }
        File f = DKUFileUtils.getWithin((File)datasetDir, (String[])new String[]{name});
        if (!f.exists() || !f.isFile()) {
            throw new IOException("File " + name + " not found in dataset " + datasetName);
        }
        DKUFileUtils.forceDelete((File)f);
    }

    public void removeFileFromUploadBox(String uploadBoxId, String name) throws IOException {
        File uploadBoxDir = FileUploadService.uploadBoxDir(uploadBoxId);
        if (!uploadBoxDir.isDirectory()) {
            throw ErrorContext.iaef((String)"Upload box dir %s does not exist or is not a directory", (Object)uploadBoxId, (Object[])new Object[0]);
        }
        File f = DKUFileUtils.getWithin((File)uploadBoxDir, (String[])new String[]{name});
        if (!f.exists() || !f.isFile()) {
            throw new IOException("File " + name + " not found in upload box " + uploadBoxId);
        }
        DKUFileUtils.forceDelete((File)f);
    }

    static {
        weirdExtensions.add("gif");
        weirdExtensions.add("jpg");
        weirdExtensions.add("png");
        weirdExtensions.add("zip");
        weirdExtensions.add("doc");
        weirdExtensions.add("docx");
        weirdExtensions.add("ppt");
        weirdExtensions.add("pptx");
        weirdExtensions.add("mp3");
        logger = Logger.getLogger((String)"dku.datasets.upload");
    }

    public static class UploadedFiles {
        public List<UploadedFile> files = new ArrayList<UploadedFile>();
        public boolean wasArchive;
    }

    public static class UploadedFile {
        public String filename;
        public String path;
        public String sheetName;
        public long length;
        public String mime;
        public boolean weird;

        public UploadedFile(String path, String filename, long length) {
            this(path, filename, null, length);
        }

        public UploadedFile(String path, String filename, String sheetName, long length) {
            this.path = path;
            this.filename = filename;
            this.length = length;
            this.mime = FileUploadService.filenameToMime(filename);
            this.weird = FileUploadService.isWeird(filename);
            this.sheetName = sheetName;
        }
    }
}

