/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.datasets.renaming.code.r;

import com.dataiku.dip.dataflow.exec.r.RRecipeMeta;
import com.dataiku.dip.recipes.code.spark.SparkRRecipeMeta;
import com.dataiku.dip.server.datasets.renaming.code.RegexCodeRenamer;
import com.dataiku.dip.server.datasets.renaming.code.RegexParser;
import com.dataiku.dip.server.datasets.renaming.code.WhitespaceParser;
import com.dataiku.dip.server.datasets.renaming.code.r.CommentParser;
import com.dataiku.dip.server.datasets.renaming.code.r.DatasetReadWriteParser;
import com.dataiku.dip.server.datasets.renaming.code.r.QuoteParser;
import com.dataiku.dip.server.datasets.renaming.code.r.SingleQuoteParser;
import com.dataiku.dip.util.DatasetLocUtils;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public final class RCodeRenamer
extends RegexCodeRenamer {
    public static final List<String> RECIPE_TYPES = Arrays.asList(RRecipeMeta.META.getType(), SparkRRecipeMeta.META.getType());
    private final List<RegexParser> parsers;

    public RCodeRenamer(String contextProjectKey, String datasetProjectKey, String datasetId) {
        this(contextProjectKey, datasetProjectKey, datasetId, datasetId);
    }

    public RCodeRenamer(String contextProjectKey, String datasetProjectKey, String oldDatasetId, String newDatasetId) {
        this(contextProjectKey, datasetProjectKey, oldDatasetId, newDatasetId, null, null);
    }

    public RCodeRenamer(String contextProjectKey, String datasetProjectKey, String oldDatasetId, String newDatasetId, String user, Date date) {
        this(contextProjectKey, contextProjectKey, new DatasetLocUtils.DatasetLoc(datasetProjectKey, oldDatasetId), new DatasetLocUtils.DatasetLoc(datasetProjectKey, newDatasetId), user, date);
    }

    public RCodeRenamer(String oldContextProjectKey, String newContextProjectKey, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset) {
        this(oldContextProjectKey, newContextProjectKey, oldDataset, newDataset, null, null);
    }

    public RCodeRenamer(String oldContextProjectKey, String newContextProjectKey, DatasetLocUtils.DatasetLoc oldDataset, DatasetLocUtils.DatasetLoc newDataset, String user, Date date) {
        super(oldContextProjectKey, newContextProjectKey, oldDataset, newDataset, user, date);
        String datasetNameRegex = oldContextProjectKey.equals(oldDataset.getProjectKey()) ? String.format("(?:%s\\.)?%s", oldDataset.getProjectKey(), oldDataset.getName()) : oldDataset.getSmartName(oldContextProjectKey);
        String datasetNameReplacement = String.format("$1\"%s\"$2", newDataset.getSmartName(newContextProjectKey));
        this.parsers = Arrays.asList(new WhitespaceParser(), new CommentParser(), new SingleQuoteParser(), new QuoteParser(), new DatasetReadWriteParser(datasetNameRegex, datasetNameReplacement));
    }

    @Override
    public List<String> getRecipeTypes() {
        return RECIPE_TYPES;
    }

    @Override
    public List<RegexParser> getParsers() {
        return this.parsers;
    }
}

