/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services;

import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.git.GitModel;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class JupyterUtils {
    public static final String GIT_KEY_GIT_REFERENCE = "gitReference";
    public static final String GIT_KEY_DKU = "dkuGit";
    static String gitKeyLastInteraction = "lastInteraction";

    private JupyterUtils() {
    }

    public static String getAssociatedRecipe(NotebookSafeForWritingNew nb) {
        return JupyterUtils.safeGetMetadataStr(nb, "associatedRecipe");
    }

    public static String getAssociatedDataset(NotebookSafeForWritingNew nb) {
        return JupyterUtils.safeGetMetadataStr(nb, "analyzedDataset");
    }

    public static String safeGetMetadataStr(NotebookSafeForWritingNew nb, String key, String emptyValue) {
        String str = JupyterUtils.safeGetMetadataStr(nb, key);
        if (str == null) {
            return emptyValue;
        }
        return str;
    }

    public static String safeGetMetadataStr(NotebookSafeForWritingNew nb, String key) {
        if (nb.metadata == null) {
            return null;
        }
        if (!nb.metadata.has(key)) {
            return null;
        }
        if (nb.metadata.get(key).isJsonNull()) {
            return null;
        }
        JsonPrimitive prim = nb.metadata.getAsJsonPrimitive(key);
        if (prim == null) {
            return null;
        }
        return prim.getAsString();
    }

    public static Long safeGetMetadataLong(NotebookSafeForWritingNew nb, String key) {
        return JupyterUtils.safeGetMetadataLong(nb, key, 0L);
    }

    public static Long safeGetMetadataLong(NotebookSafeForWritingNew nb, String key, Long defaultValue) {
        String value = JupyterUtils.safeGetMetadataStr(nb, key);
        if (value == null) {
            return defaultValue;
        }
        return Long.decode(value);
    }

    public static JsonObject safeGetMetadataJsonObject(NotebookSafeForWritingNew nb, String key) {
        if (nb.metadata == null || !nb.metadata.has(key) || !nb.metadata.get(key).isJsonObject()) {
            return null;
        }
        return nb.metadata.getAsJsonObject(key);
    }

    public static JupyterKernelSpecInNotebook getKernelSpecInfo(NotebookSafeForWritingNew nb) {
        if (nb.metadata != null) {
            if (nb.metadata.has("kernelspec")) {
                return (JupyterKernelSpecInNotebook)JSON.parse((JsonElement)nb.metadata.get("kernelspec"), JupyterKernelSpecInNotebook.class);
            }
            if (nb.metadata.has("language_info") && nb.metadata.getAsJsonObject("language_info").has("name")) {
                JupyterKernelSpecInNotebook kernelSpec = new JupyterKernelSpecInNotebook();
                kernelSpec.name = nb.metadata.getAsJsonObject("language_info").get("name").getAsString();
                return kernelSpec;
            }
            if (nb.metadata.has("application/vnd.databricks.v1+notebook") && nb.metadata.getAsJsonObject("application/vnd.databricks.v1+notebook").has("language")) {
                JupyterKernelSpecInNotebook kernelSpec = new JupyterKernelSpecInNotebook();
                kernelSpec.name = StringUtils.capitalize((String)nb.metadata.getAsJsonObject("application/vnd.databricks.v1+notebook").get("language").getAsString());
                return kernelSpec;
            }
        }
        return null;
    }

    public static Long getLastGitInteraction(NotebookSafeForWritingNew notebook) {
        if (notebook.metadata == null || !notebook.metadata.has(GIT_KEY_DKU) || notebook.metadata.get(GIT_KEY_DKU) == null || !notebook.metadata.get(GIT_KEY_DKU).isJsonObject()) {
            return 0L;
        }
        JsonObject dkuMetadata = notebook.metadata.getAsJsonObject(GIT_KEY_DKU);
        if (dkuMetadata == null || !dkuMetadata.has(gitKeyLastInteraction) || dkuMetadata.get(gitKeyLastInteraction) == null || !dkuMetadata.get(gitKeyLastInteraction).isJsonPrimitive()) {
            return 0L;
        }
        return dkuMetadata.getAsJsonPrimitive(gitKeyLastInteraction).getAsLong();
    }

    public static String getCreator(NotebookSafeForWritingNew nb) {
        return JupyterUtils.safeGetMetadataStr(nb, "creator");
    }

    public static void setCreationTag(NotebookSafeForWritingNew nb, JupyterNotebookListEntry jupyterNbk) {
        if (jupyterNbk.creator != null) {
            long defaultValue = jupyterNbk.lastModifiedOn != 0L ? jupyterNbk.lastModifiedOn : System.currentTimeMillis();
            jupyterNbk.creationTag = new VersionTag(jupyterNbk.creator, JupyterUtils.safeGetMetadataLong(nb, "createdOn", defaultValue), 0L);
        }
    }

    public static void setVersionTag(NotebookSafeForWritingNew nb, JupyterNotebookListEntry jupyterNbk) {
        String modifiedBy = JupyterUtils.safeGetMetadataStr(nb, "modifiedBy", jupyterNbk.creator);
        if (modifiedBy != null) {
            jupyterNbk.versionTag = new VersionTag(modifiedBy, jupyterNbk.lastModifiedOn, 1L);
        }
    }

    public static boolean isAutomationLocal(NotebookSafeForWritingNew nb) {
        return nb.metadata != null && nb.metadata.has("automationLocal");
    }

    public static List<String> readTagMetadata(NotebookSafeForWritingNew nb, List<String> tags) {
        if (nb.metadata != null && nb.metadata.has("tags")) {
            JsonArray array = nb.metadata.getAsJsonArray("tags");
            for (JsonElement elt : array) {
                tags.add(elt.getAsString());
            }
        }
        return tags;
    }

    public static RelFile getNotebooksDir(RelFile projectRootDir) {
        return new RelFile(projectRootDir, new String[]{"ipython_notebooks"});
    }

    public static RelFile getProjectRootDir(String projectKey) {
        return new RelFile(new String[]{"projects", projectKey});
    }

    public static class NotebookSafeForWritingNew {
        public JsonObject metadata;
        public int nbformat;
        public int nbformat_minor;
        public List<CellForWriting> cells = new ArrayList<CellForWriting>();

        public NotebookSafeForWritingNew copyWithoutCellsOutputs() {
            NotebookSafeForWritingNew result = new NotebookSafeForWritingNew();
            result.metadata = this.metadata;
            result.nbformat = this.nbformat;
            result.nbformat_minor = this.nbformat_minor;
            result.cells = this.cells.stream().map(CellForWriting::copyWithoutOutputs).collect(Collectors.toList());
            return result;
        }
    }

    public static class JupyterKernelSpecInNotebook {
        public String name;
        public String language;
        public String display_name;
    }

    public static class JupyterNotebookListEntry
    extends TaggableObjectsService.TaggableObject {
        public String projectKey;
        public String name;
        public String language;
        public DisplayKernelSpec displayKernelSpec;
        public boolean automationLocal;
        public String associatedRecipe;
        public String analyzedDataset;
        public String creator;
        public List<ActiveSession> activeSessions = new ArrayList<ActiveSession>();
        public long lastModifiedOn;
        public GitModel.GitReference gitReference;
        public long lastGitInteraction;

        @Override
        public ITaggingService.TaggableType getTaggableType() {
            return ITaggingService.TaggableType.JUPYTER_NOTEBOOK;
        }

        @Override
        public String getProjectKey() {
            return this.projectKey;
        }

        @Override
        public String getId() {
            return this.name;
        }

        @Override
        public String getDisplayName() {
            return this.name;
        }

        @Override
        public void setProjectKey(String projectKey) {
            this.projectKey = projectKey;
        }

        @Override
        public void setId(String id) {
            this.name = id;
        }
    }

    public static class CellForWriting {
        public Integer execution_count = 0;
        public String cell_type = "code";
        public JsonObject metadata = new JsonObject();
        public List<String> source = new ArrayList<String>();
        public List<JsonObject> outputs = new ArrayList<JsonObject>();

        public static void registerAdapter() {
            JSON.registerAdapter(CellForWriting.class, (Object)new JSON.Adapter<CellForWriting>(){

                public CellForWriting deserialize(JsonElement json, Type type, JsonDeserializationContext ctx) {
                    CellForWriting cell = new CellForWriting();
                    JsonObject jsonObj = json.getAsJsonObject();
                    if (jsonObj.get("execution_count") != null && !jsonObj.get("execution_count").isJsonNull()) {
                        cell.execution_count = jsonObj.get("execution_count").getAsInt();
                    }
                    if (jsonObj.get("cell_type") != null && !jsonObj.get("cell_type").isJsonNull()) {
                        cell.cell_type = jsonObj.get("cell_type").getAsString();
                    }
                    if (jsonObj.get("metadata") != null && jsonObj.get("metadata").isJsonObject()) {
                        cell.metadata = jsonObj.get("metadata").getAsJsonObject();
                    }
                    if (jsonObj.get("source") != null) {
                        if (jsonObj.get("source").isJsonArray()) {
                            for (JsonElement sourceLine : jsonObj.get("source").getAsJsonArray()) {
                                if (!sourceLine.isJsonPrimitive()) continue;
                                cell.source.add(sourceLine.getAsString());
                            }
                        } else if (!jsonObj.get("source").isJsonNull()) {
                            cell.source.add(jsonObj.get("source").getAsString());
                        }
                    }
                    if (jsonObj.get("outputs") != null && jsonObj.get("outputs").isJsonArray()) {
                        for (JsonElement output : jsonObj.get("outputs").getAsJsonArray()) {
                            if (!output.isJsonObject()) continue;
                            cell.outputs.add(output.getAsJsonObject());
                        }
                    }
                    return cell;
                }

                public JsonElement serialize(CellForWriting params, Type type, JsonSerializationContext ctx) {
                    JsonObject jsonObj = new JsonObject();
                    if ("code".equals(params.cell_type)) {
                        jsonObj.add("execution_count", (JsonElement)new JsonPrimitive((Number)params.execution_count));
                    }
                    jsonObj.add("cell_type", (JsonElement)new JsonPrimitive(params.cell_type));
                    jsonObj.add("metadata", (JsonElement)params.metadata);
                    JsonArray sourceArray = JSON.toJsonArray(params.source);
                    jsonObj.add("source", (JsonElement)sourceArray);
                    JsonArray outputArray = JSON.toJsonArray(params.outputs);
                    if ("code".equals(params.cell_type)) {
                        jsonObj.add("outputs", (JsonElement)outputArray);
                    }
                    return jsonObj;
                }
            });
        }

        public CellForWriting copyWithoutOutputs() {
            CellForWriting result = new CellForWriting();
            result.source = this.source;
            result.cell_type = this.cell_type;
            result.metadata = this.metadata;
            result.outputs = new ArrayList<JsonObject>();
            result.execution_count = 0;
            return result;
        }
    }

    public static class ActiveSession {
        public String projectKey;
        public String notebookName;
        public String sessionCreator;
        public String sessionCreatorDisplayName;
        public String sessionUnixOwner;
        public String sessionId;
        public String kernelId;
        public Integer kernelPid;
        public int kernelConnections;
        public long kernelLastActivityTime;
        public String kernelExecutionState;
        public long sessionStartTime;
    }

    public static class DisplayKernelSpec {
        public String name;
        public String envName;
        public String projectKey;
        public String bundleId;
        public String containerConf;
    }
}

