/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.filter;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.memimpl.MemRow;
import com.dataiku.dip.datalayer.memimpl.MemTable;
import com.dataiku.dip.pivot.backend.dss.facets.DateAxisFaceter;
import com.dataiku.dip.pivot.backend.model.FilterFacet;
import com.dataiku.dip.pivot.frontend.model.ChartFilter;
import com.dataiku.dip.shaker.DateRelativeFilterHelper;
import com.dataiku.dip.shaker.filter.Faceter;
import com.dataiku.dip.shaker.filter.FilterRequest;
import com.dataiku.dip.shaker.types.AnyTemporal;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dss.shadelib.org.joda.time.DateTime;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInstant;
import com.dataiku.dss.shadelib.org.joda.time.ReadableInterval;
import gnu.trove.list.array.TLongArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class DateFaceter
extends Faceter {
    private final AnyTemporal anyTemporalType = new AnyTemporal();
    private final ChartFilter.DateFilterPart dateFilterPart;
    private final ChartFilter.DateFilterType dateFilterType;
    private final ChartFilter.DateRelativeOption dateFilterOption;
    private final TLongArrayList list = new TLongArrayList();
    private final SortedMap<Integer, Integer> values = new TreeMap<Integer, Integer>();
    private long min = Long.MAX_VALUE;
    private long max = Long.MIN_VALUE;
    private final Calendar cal = DKUtils.getUTCCalendar();

    public DateFaceter(String column, ChartFilter.DateFilterType dateFilterType, ChartFilter.DateFilterPart dateFilterPart, ChartFilter.DateRelativeOption dateFilterOption) {
        if (dateFilterType == null) {
            dateFilterType = ChartFilter.DateFilterType.RANGE;
        }
        if (dateFilterPart == null && (dateFilterType == ChartFilter.DateFilterType.RANGE || dateFilterType == ChartFilter.DateFilterType.RELATIVE)) {
            dateFilterPart = ChartFilter.DateFilterPart.YEAR;
        }
        this.column = column;
        this.dateFilterType = dateFilterType;
        this.dateFilterPart = dateFilterPart;
        this.dateFilterOption = dateFilterOption;
    }

    @Override
    protected void observe(MemTable table, Column cd, boolean[] filters) {
        for (int i = 0; i < table.rows.size(); ++i) {
            long ts;
            MemRow r = table.rows.get(i);
            if (!filters[i] || (ts = this.anyTemporalType.longValue(r.get(cd))) == Long.MAX_VALUE) continue;
            if (this.dateFilterType == ChartFilter.DateFilterType.RANGE) {
                this.min = Math.min(ts, this.min);
                this.max = Math.max(ts, this.max);
                continue;
            }
            if (this.dateFilterType == ChartFilter.DateFilterType.RELATIVE) continue;
            this.cal.setTimeInMillis(ts);
            int binId = DateAxisFaceter.getBinId(this.dateFilterPart, ts, this.cal);
            if (this.dateFilterPart == ChartFilter.DateFilterPart.INDIVIDUAL) {
                if (this.values.containsKey(binId)) {
                    this.values.put(binId, (Integer)this.values.get(binId) + 1);
                    continue;
                }
                this.values.put(binId, 1);
                continue;
            }
            while (this.list.size() < binId + 1) {
                this.list.add(0L);
            }
            this.list.set(binId, this.list.get(binId) + 1L);
        }
    }

    @Override
    public FilterFacet compute() {
        FilterFacet ff = new FilterFacet();
        ff.column = this.column;
        ff.isRange = this.dateFilterType == ChartFilter.DateFilterType.RANGE;
        ff.type = FilterRequest.FilterType.DATE_FACET;
        if (this.dateFilterType == ChartFilter.DateFilterType.RANGE) {
            ff.minValue = this.min;
            ff.maxValue = this.max;
        } else if (this.dateFilterType == ChartFilter.DateFilterType.RELATIVE) {
            ff.part = this.dateFilterPart;
            ff.option = this.dateFilterOption;
            this.calculateIntervalForRelativeFilter(ff);
        } else if (this.dateFilterPart == ChartFilter.DateFilterPart.INDIVIDUAL) {
            for (Map.Entry<Integer, Integer> entry : this.values.entrySet()) {
                Integer key = entry.getKey();
                Integer value = entry.getValue();
                ff.values.add(new FilterFacet.Val("" + key, DateAxisFaceter.getLabel(this.dateFilterPart, key.intValue()), (long)value.intValue()));
            }
        } else {
            this.addValuesToFilterFacet(ff);
        }
        return ff;
    }

    private void calculateIntervalForRelativeFilter(FilterFacet ff) {
        if (this.dateFilterOption != null) {
            DateTime now = new DateTime().withZone(DateTimeZone.UTC);
            ReadableInterval bounds = DateRelativeFilterHelper.computeInterval(this.dateFilterPart, this.dateFilterOption, (ReadableInstant)now);
            ff.minValue = bounds.getStartMillis();
            ff.maxValue = bounds.getEndMillis();
        }
    }

    private void addValuesToFilterFacet(FilterFacet ff) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i) <= 0L) continue;
            ff.values.add(new FilterFacet.Val("" + i, DateAxisFaceter.getLabel(this.dateFilterPart, i), this.list.get(i)));
        }
    }
}

