/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.mrimpl.formats;

import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SimpleKeyValue;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRow;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.formats.FormatFactory;
import com.dataiku.dip.formats.custom.CustomJavaFormatExtractor;
import com.dataiku.dip.formats.custom.CustomJavaFormatMeta;
import com.dataiku.dip.formats.custom.CustomJavaFormatParams;
import com.dataiku.dip.plugin.InputStreamWithContextInfo;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.shaker.mrimpl.formats.CustomJavaFormatDependenciesHandler;
import com.dataiku.dip.shaker.mrimpl.formats.RowWithFactories;
import com.dataiku.dip.shaker.mrimpl.models.DatasetConfig;
import com.dataiku.dip.warnings.WarningsContext;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.log4j.Logger;

public class CustomJavaFormatInputAdapter
extends FileInputFormat<Void, RowWithFactories> {
    private final CustomJavaFormatParams formatParams;
    private final String formatType;
    private final Schema inputSchema;
    private final WarningsContext warningsContext;
    private final ColumnFactory cf;
    private final RowFactory rf;
    private final String projectKey;
    private static Logger logger = Logger.getLogger((String)"dip.shaker.mr.custom.java.input");

    public CustomJavaFormatInputAdapter(ColumnFactory cf, RowFactory rf, DatasetConfig inputConf, WarningsContext warningsContext) {
        this.cf = cf;
        this.rf = rf;
        this.formatType = inputConf.dataset.formatType;
        this.projectKey = inputConf.dataset.getProjectKey();
        this.formatParams = (CustomJavaFormatParams)inputConf.dataset.getFormatParams();
        this.inputSchema = inputConf.dataset.getSchema();
        this.warningsContext = (WarningsContext)Preconditions.checkNotNull((Object)warningsContext);
    }

    public static void registerDependencies(AuthCtx authCtx, Dataset dataset, List<SimpleKeyValue> configKeys, List<File> resourceJars) throws IOException, DKUSecurityException {
        CustomJavaFormatDependenciesHandler.registerDependencies(authCtx, ".input", dataset, configKeys, resourceJars);
    }

    public static void loadDependencies(Configuration hadoopConf) throws IOException {
        CustomJavaFormatDependenciesHandler.loadDependencies(".input", hadoopConf);
    }

    public boolean isSplitable(JobContext context, Path path) {
        return false;
    }

    public RecordReader<Void, RowWithFactories> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        CustomJavaFormatMeta formatMeta = (CustomJavaFormatMeta)FormatFactory.getMeta(this.formatType);
        CustomJavaFormatExtractor formatExtractor = (CustomJavaFormatExtractor)formatMeta.build(DSSAuthCtx.newNone(), this.projectKey, this.formatParams);
        formatExtractor.setSchema(this.inputSchema, true);
        formatExtractor.setWarningsContext(this.warningsContext);
        return new InternalRecordReader(formatExtractor);
    }

    private class InternalRecordReader
    extends RecordReader<Void, RowWithFactories> {
        private final CustomJavaFormatExtractor formatExtractor;
        private FSDataInputStream dataInputStream;
        private InputStream is;
        private RowWithFactories currentRow;
        private ExtractionThread extractionThread;
        private ExtractedRowsQueue rowsQueue;

        InternalRecordReader(CustomJavaFormatExtractor formatExtractor) {
            this.rowsQueue = new ExtractedRowsQueue();
            this.formatExtractor = formatExtractor;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            Path file = ((FileSplit)split).getPath();
            FileSystem fs = file.getFileSystem(context.getConfiguration());
            this.dataInputStream = fs.open(file);
            this.is = this.dataInputStream.getWrappedStream();
            this.extractionThread = new ExtractionThread(new InputStreamWithContextInfo(this.is, file.getName(), file.getName(), null, () -> this.getModificationTime(fs, file)), this.formatExtractor, this.rowsQueue);
            this.extractionThread.start();
        }

        private long getModificationTime(FileSystem fs, Path file) {
            try {
                return fs.getFileStatus(file).getModificationTime();
            }
            catch (IOException e) {
                return 0L;
            }
        }

        public void close() throws IOException {
            this.is.close();
            this.dataInputStream.close();
        }

        public Void getCurrentKey() throws IOException, InterruptedException {
            return null;
        }

        public RowWithFactories getCurrentValue() throws IOException, InterruptedException {
            return this.currentRow;
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            Row row = this.rowsQueue.nextRow();
            if (this.rowsQueue.isCancelled()) {
                throw new IOException("Reading cancelled");
            }
            if (row == null) {
                this.is.close();
                return false;
            }
            this.currentRow = new RowWithFactories(CustomJavaFormatInputAdapter.this.cf, CustomJavaFormatInputAdapter.this.rf, row);
            return true;
        }
    }

    private class ExtractionThread
    extends Thread {
        private final CustomJavaFormatExtractor formatExtractor;
        private final ExtractedRowsQueue rowsQueue;
        private final InputStreamWithContextInfo inputStream;

        public ExtractionThread(InputStreamWithContextInfo inputStream, CustomJavaFormatExtractor formatExtractor, ExtractedRowsQueue rowsQueue) {
            this.inputStream = inputStream;
            this.formatExtractor = formatExtractor;
            this.rowsQueue = rowsQueue;
        }

        @Override
        public void run() {
            try {
                this.formatExtractor.doExtractStream(this.inputStream, this.rowsQueue, CustomJavaFormatInputAdapter.this.cf, CustomJavaFormatInputAdapter.this.rf, null);
                this.rowsQueue.lastRowEmitted();
            }
            catch (Exception e) {
                try {
                    this.rowsQueue.cancel();
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)"Cancellation problem", (Throwable)e1);
                }
            }
        }
    }

    private class ExtractedRowsQueue
    implements ProcessorOutput {
        private Row poison = new StreamRow();
        private ArrayBlockingQueue<Row> rows = new ArrayBlockingQueue(100);
        private boolean cancelled = false;
        private boolean readDone = false;

        private ExtractedRowsQueue() {
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public Row nextRow() throws InterruptedException {
            if (this.readDone) {
                return null;
            }
            Row row = this.rows.take();
            if (row == this.poison) {
                this.readDone = true;
                return null;
            }
            return row;
        }

        public void emitRow(Row row) throws Exception {
            this.rows.put(row);
        }

        public void lastRowEmitted() throws Exception {
            this.rows.put(this.poison);
        }

        public void cancel() throws InterruptedException {
            this.cancelled = true;
            this.rows.put(this.poison);
        }

        public void setMaxMemoryUsed(long size) {
        }
    }
}

