/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.cleansing;

import com.dataiku.dip.classpathfix.DKUDoubles;
import com.dataiku.dip.classpathfix.DKULongs;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnDeletionSensitiveProcessor;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalineage.RecipeLineage;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.shaker.ProcessorWithRecordedReport;
import com.dataiku.dip.shaker.model.ProcessorScriptStep;
import com.dataiku.dip.shaker.model.ScriptStep;
import com.dataiku.dip.shaker.model.StepParams;
import com.dataiku.dip.shaker.processors.AppliesToProcessor;
import com.dataiku.dip.shaker.processors.Category;
import com.dataiku.dip.shaker.processors.ProcessorCapabilities;
import com.dataiku.dip.shaker.processors.ProcessorMeta;
import com.dataiku.dip.shaker.processors.ProcessorTag;
import com.dataiku.dip.shaker.server.ProcessorDesc;
import com.dataiku.dip.shaker.sql.ProcessorSQLTranslator;
import com.dataiku.dip.shaker.sql.SQLQueryWithSchema;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.queries.ExpressionBuilder;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class FillEmptyWithValue {
    public static final ProcessorMeta<StreamImpl, Parameter> META = new ProcessorMeta<StreamImpl, Parameter>(){

        @Override
        public String getName() {
            return "FillEmptyWithValue";
        }

        @Override
        public ProcessorMeta.ProcessorCapabilitiesSummary getCapabilities(StepParams params, ProcessorWithRecordedReport.ProcessorRecordedReport report, SQLDialect dialect) {
            return new ProcessorMeta.ProcessorCapabilitiesSummary().withCan(ProcessorCapabilities.SQL_TRANSLATABLE, ProcessorCapabilities.NATIVE_SPARK_IMPL, ProcessorCapabilities.TYPE_FIXED_COLUMNS_CREATOR, ProcessorCapabilities.KNOWN_INPUTS, ProcessorCapabilities.KNOWN_OUTPUTS);
        }

        @Override
        public String getDocPage() {
            return "fill-empty";
        }

        @Override
        public Category getCategory() {
            return Category.CLEANSING;
        }

        @Override
        public Set<ProcessorTag> getTags() {
            return Sets.newHashSet((Object[])new ProcessorTag[]{ProcessorTag.CLEANSING});
        }

        @Override
        public Class<Parameter> stepParamClass() {
            return Parameter.class;
        }

        @Override
        public String getHelp(String language) {
            return this.translate(language, "SHAKER.PROCESSOR.FillEmptyWithValue.HELP", "Fill the empty cells in a column with a fixed value. \n# Options\n**Column**\nApply fill to the following: \n* A single column\n* An explicit list of columns\n* All columns matching a regex pattern\n* All columns\n**Value to fill with**\nEnter the value with which to fill empty cells.");
        }

        @Override
        public ProcessorDesc describe(String language) {
            return ProcessorDesc.withGenericForm(this.getName(), this.translate(language, "SHAKER.PROCESSOR.FillEmptyWithValue.DESCRIPTION", 1.actionVerb("Fill") + " empty cells with fixed value")).withMNESParam("value", this.translate(language, "SHAKER.PROCESSOR.FillEmptyWithValue.DESCRIPTION.VALUE", "Value to fill with"));
        }

        @Override
        public Object selfReport(Parameter parameter) {
            JsonObject obj = AppliesToProcessor.selfReport(parameter);
            obj.remove("value");
            return obj;
        }

        @Override
        public StreamImpl build(Parameter parameter) throws Exception {
            return new StreamImpl(parameter);
        }

        @Override
        public ProcessorSQLTranslator getSQLTranslator(StepParams parameter, ProcessorWithRecordedReport.ProcessorRecordedReport report) {
            return new SQLTranslator((Parameter)parameter);
        }

        @Override
        public String getNativeSparkClassname() {
            return "com.dataiku.dip.shaker.processors.cleansing.FillEmptyWithValueNS";
        }

        @Override
        public RecipeLineage getUpdatedRecipeLineage(ProcessorScriptStep pss, RecipeLineage previousRecipeLineage) {
            if (!(pss.params instanceof Parameter)) {
                throw new IllegalArgumentException("Unsupported param type: " + pss.params.getClass().getSimpleName());
            }
            return previousRecipeLineage;
        }
    };

    private static class StreamImpl
    extends AppliesToProcessor
    implements ColumnDeletionSensitiveProcessor {
        final Parameter parameter;

        private StreamImpl(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public AppliesToProcessor.AppliesToParams getParams() {
            return this.parameter;
        }

        @Override
        public void processRowForColumns(Row row, Iterable<Column> columns) throws Exception {
            for (Column cd : columns) {
                String cur = row.get(cd);
                if (cur != null) continue;
                row.put(cd, this.parameter.value);
            }
        }

        public void postProcess() {
        }

        @Nullable
        public InfoMessage getDeletedColumnsWarningMessage() {
            if (this.getParams().appliesTo == AppliesToProcessor.AppliesTo.ALL || this.getParams().appliesTo == AppliesToProcessor.AppliesTo.PATTERN) {
                return InfoMessage.warning((InfoMessage.MessageCode)ScriptStep.StepCodes.WARN_DELETED_COLUMN_MAY_BE_USED, (String)"This processor may produce unexpected results when used after a delete or rename processor on the DSS engine. It is recommended to split the steps into two separate recipes.");
            }
            return null;
        }
    }

    private static class SQLTranslator
    implements ProcessorSQLTranslator {
        private final Parameter parameter;

        private SQLTranslator(Parameter parameter) {
            this.parameter = parameter;
        }

        @Override
        public SQLQueryWithSchema translate(SQLQueryWithSchema input) {
            ExpressionBuilder.ExpressionBuilderFactory ebf = new ExpressionBuilder.ExpressionBuilderFactory();
            List<String> appliesToColumns = input.getAppliesToColumns(this.parameter);
            if (input.isAnyCreatedOrModifiedByCurrentQuery(appliesToColumns)) {
                input = input.makeSubquery();
            }
            for (String column : appliesToColumns) {
                ExpressionBuilder eb;
                if (input.getSelectedIndex(column) < 0 || !input.getInputColumn(column).isPresent()) {
                    throw new IllegalArgumentException("There is no column name or alias with the name '" + column + "'");
                }
                SchemaColumn inputColumn = (SchemaColumn)input.getInputColumn(column).get();
                ExpressionBuilder replacement = ebf.cst(this.parameter.value);
                SchemaColumn schemaColumn = input.getMandatoryCurrentColumn(column);
                replacement = replacement.cast(schemaColumn.getType(), schemaColumn.maxLength);
                if (inputColumn.getType() == Type.STRING) {
                    eb = input.col(column).coalesceNullOrEmptyString(replacement);
                } else {
                    SQLDialect d = input.getDialect();
                    eb = ebf.caseWhen(input.col(column).castToString(d.getDefaultVarcharLen()).eq(ebf.cst("")), ebf.cst(null), input.col(column)).cast(schemaColumn.getType(), schemaColumn.maxLength).coalesce(replacement);
                }
                input.replaceSelect(column, eb, column);
                boolean valueIsInteger = DKULongs.tryParse((String)this.parameter.value) != null;
                boolean valueIsDouble = DKUDoubles.tryParse((String)this.parameter.value) != null;
                Type outputType = null;
                outputType = inputColumn.getType().isInteger() && valueIsInteger ? inputColumn.getType() : (inputColumn.getType().isNumeric() && valueIsDouble ? Type.DOUBLE : Type.STRING);
                SchemaColumn modifiedColumn = (SchemaColumn)JSON.deepCopy((Object)inputColumn);
                modifiedColumn.setType(outputType);
                input.replaceColumn(modifiedColumn);
            }
            return input;
        }
    }

    public static class Parameter
    extends AppliesToProcessor.AppliesToParams {
        private static final long serialVersionUID = -1L;
        public String value;
    }
}

