/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.shaker.processors.udf;

import com.dataiku.dip.datalayer.Column;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.Processor;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.Row;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.io.AbstractImpersonableSecretProtectedPythonKernel;
import com.dataiku.dip.shaker.processors.udf.AbstractPythonUDF;
import com.dataiku.dip.shaker.processors.udf.CustomJythonStepParams;
import com.dataiku.dip.shaker.processors.udf.JythonUDFUtils;
import com.dataiku.dip.shaker.processors.udf.LoadedJythonProcessor;
import com.dataiku.dip.shaker.processors.udf.PythonParameter;
import com.dataiku.dip.shaker.processors.udf.PythonUDFModeHandler;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyObject;

public class PythonUDFRow
implements PythonUDFModeHandler {
    private final String errorColumnName;
    private Column errorColumn;

    public PythonUDFRow(PythonParameter parameter) {
        this.errorColumnName = parameter.errorColumn;
    }

    public PythonUDFRow(LoadedJythonProcessor loaded, CustomJythonStepParams params) {
        this.errorColumnName = params.errorColumn;
    }

    @Override
    public void emitFromJython(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, PyObject result) throws Exception {
        if (result == Py.None) {
            return;
        }
        if (!(result instanceof PyDictionary)) {
            throw new IllegalArgumentException("In Row mode, script should return a dictionary.");
        }
        PyDictionary newRowDic = (PyDictionary)result;
        Row newRow = JythonUDFUtils.formatRow(cf, rf, newRowDic);
        processorOutput.emitRow(newRow);
    }

    @Override
    public void errorFromJython(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, PyException e) throws Exception {
        if (this.errorColumn != null) {
            for (Column col : cf.columns()) {
                row.put(col, "ERROR");
            }
            row.put(this.errorColumn, JythonUDFUtils.formatPyException(e));
            processorOutput.emitRow(row);
        } else {
            boolean first = true;
            for (Column col : cf.columns()) {
                if (first) {
                    first = false;
                    row.put(col, JythonUDFUtils.formatPyException(e));
                    continue;
                }
                row.put(col, "ERROR");
            }
            processorOutput.emitRow(row);
        }
    }

    @Override
    public void emitFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, Object result) throws Exception {
        Row newRow = JythonUDFUtils.deltaToRow(cf, rf, row, result);
        if (newRow == null) {
            return;
        }
        processorOutput.emitRow(newRow);
    }

    @Override
    public void emitVectorFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, List<Row> rows, List<Integer> indices, Object result) throws Exception {
        if (indices.size() != rows.size()) {
            throw new Exception("Vectorized udf did not return vector of same length (" + indices.size() + " , expected " + rows.size() + ")");
        }
        if (result == null) {
            for (int i = 0; i < rows.size(); ++i) {
                processorOutput.emitRow(rf.row());
            }
        } else {
            AbstractPythonUDF.RowDelta delta = (AbstractPythonUDF.RowDelta)JSON.parse((String)JSON.json((Object)result), AbstractPythonUDF.RowDelta.class);
            if (delta.__dku_added_columns != null && delta.__dku_deleted_columns != null) {
                ArrayList<AbstractPythonUDF.RowDelta> deltas = new ArrayList<AbstractPythonUDF.RowDelta>();
                for (int i = 0; i < rows.size(); ++i) {
                    AbstractPythonUDF.RowDelta d = new AbstractPythonUDF.RowDelta();
                    d.__dku_deleted_columns = delta.__dku_deleted_columns;
                    d.__dku_added_columns = new JsonObject();
                    deltas.add(d);
                }
                for (Map.Entry e : delta.__dku_added_columns.entrySet()) {
                    List<Object> v = JythonUDFUtils.unvectorizeToList(e.getValue());
                    if (v.size() != rows.size()) {
                        throw new Exception("Vectorized function changed the vector size for " + (String)e.getKey());
                    }
                    for (int i = 0; i < rows.size(); ++i) {
                        ((AbstractPythonUDF.RowDelta)deltas.get((int)i)).__dku_added_columns.add((String)e.getKey(), JSON.toJsonElement((Object)v.get(i)));
                    }
                }
                for (int i = 0; i < rows.size(); ++i) {
                    this.emitFromKernel(processorOutput, cf, rf, rows.get(i), deltas.get(i));
                }
            } else {
                JsonObject dict = (JsonObject)JSON.parse((String)JSON.json((Object)result), JsonObject.class);
                ArrayList<JsonObject> dicts = new ArrayList<JsonObject>();
                for (int i = 0; i < rows.size(); ++i) {
                    dicts.add(new JsonObject());
                }
                for (Map.Entry e : dict.entrySet()) {
                    List<Object> v = JythonUDFUtils.unvectorizeToList(e.getValue());
                    if (v.size() != rows.size()) {
                        throw new Exception("Vectorized function changed the vector size for " + (String)e.getKey());
                    }
                    for (int i = 0; i < rows.size(); ++i) {
                        ((JsonObject)dicts.get(i)).add((String)e.getKey(), JSON.toJsonElement((Object)v.get(i)));
                    }
                }
                for (int i = 0; i < rows.size(); ++i) {
                    this.emitFromKernel(processorOutput, cf, rf, rows.get(i), dicts.get(i));
                }
            }
        }
    }

    @Override
    public void errorFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, Row row, AbstractImpersonableSecretProtectedPythonKernel.PythonError e) throws Exception {
        if (this.errorColumn != null) {
            for (Column col : cf.columns()) {
                row.put(col, "ERROR");
            }
            row.put(this.errorColumn, e.getSerializedThrowable().getMessage());
            processorOutput.emitRow(row);
        } else {
            boolean first = true;
            for (Column col : cf.columns()) {
                if (first) {
                    first = false;
                    row.put(col, e.getSerializedThrowable().getMessage());
                    continue;
                }
                row.put(col, "ERROR");
            }
            processorOutput.emitRow(row);
        }
    }

    @Override
    public void errorVectorFromKernel(ProcessorOutput processorOutput, ColumnFactory cf, RowFactory rf, List<Row> rows, AbstractImpersonableSecretProtectedPythonKernel.PythonError e) throws Exception {
        for (Row row : rows) {
            this.errorFromKernel(processorOutput, cf, rf, row, e);
        }
    }

    @Override
    public void initModeSpecific(ColumnFactory cf) throws Exception {
        this.errorColumn = StringUtils.isBlank((String)this.errorColumnName) ? null : cf.column(this.errorColumnName, Processor.ProcessorRole.OUTPUT_COLUMN);
    }
}

