/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.GenericSQLDialect;
import com.dataiku.dip.sql.queries.QuotedPortionFinderFactory;
import com.dataiku.dip.sql.queries.QuotedPortionFinders;

public class AsterDataSQLDialect
extends GenericSQLDialect {
    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "real", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double precision", new Integer[]{7, 2, 3});
            }
            case STRING: {
                return new DSSTypeSQLMapping(Type.STRING, 12, (String)(schemaColumn.getMaxLength() == -1 || schemaColumn.getMaxLength() > 0xA00000 ? "text" : "varchar(" + schemaColumn.getMaxLength() + ")"), new Integer[]{2003, 1, 1111, -16, -1, -9, 92});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 93, "timestamptz", new Integer[]{91});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public String getCreateTableStatementSQL(AbstractSQLConnection connection, Dataset dataset, InfoMessage.InfoMessages messages, boolean ifNotExist) {
        assert (!ifNotExist);
        return super.getCreateTableStatementSQL(connection, dataset, messages, ifNotExist);
    }

    @Override
    public String getLimitedQuery(String query, long size) {
        return this.getLimitedQueryUsingLimit(query, size);
    }

    @Override
    public QuotedPortionFinderFactory[] getSemicolonExclusionPortionFinders() {
        return new QuotedPortionFinderFactory[]{QuotedPortionFinders.SingleLineCommentFinder.META, QuotedPortionFinders.MultiLineCommentFinder.META, QuotedPortionFinders.SingleQuotedNoEscapeFinder.META, QuotedPortionFinders.DoubleQuotedNoEscapeFinder.META};
    }

    @Override
    public int getIdentifiersMaxLength() {
        return -1;
    }

    @Override
    public boolean supportsInDatabaseCharts() {
        return false;
    }

    @Override
    public String getId() {
        return "AsterData";
    }
}

