/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.datasets.DatasetRecordCount;
import com.dataiku.dip.datasets.Type;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.sql.DSSTypeSQLMapping;
import com.dataiku.dip.sql.PostgresLikeSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.metadata.DatabaseObjectKey;
import com.dataiku.dip.sql.queries.QueryAst;
import com.dataiku.dip.sql.queries.QueryUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.joda.time.DateTimeZone;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.WKBReader;

public class PostgreSQLDialect
extends PostgresLikeSQLDialect {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.sql.postgresql");
    public static final WKBReader WKB_READER = new WKBReader(new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 4326));
    boolean useGeography = DKUApp.getParams().getBoolParam("dku.datasets.postgresql.postgis.useGeography", true);

    @Override
    public boolean supportsCaseInsensitivityRegExp() {
        return true;
    }

    @Override
    public DSSTypeSQLMapping getSQLType(SchemaColumn schemaColumn, Dataset dataset) {
        switch (schemaColumn.getType()) {
            case TINYINT: {
                return new DSSTypeSQLMapping(Type.TINYINT, 5, "smallint", new Integer[0]);
            }
            case FLOAT: {
                return new DSSTypeSQLMapping(Type.FLOAT, 6, "real", new Integer[]{7, 2});
            }
            case DOUBLE: {
                return new DSSTypeSQLMapping(Type.DOUBLE, 8, "double precision", new Integer[]{7, 2});
            }
            case DATE: {
                return new DSSTypeSQLMapping(Type.DATE, 2014, "timestamptz", new Integer[]{91, 93});
            }
            case DATEONLY: {
                return new DSSTypeSQLMapping(Type.DATEONLY, 91, "date", new Integer[]{93, 2014});
            }
            case DATETIMENOTZ: {
                return new DSSTypeSQLMapping(Type.DATETIMENOTZ, 93, "timestamp", new Integer[]{91, 2014});
            }
            case STRING: {
                if (schemaColumn.getMaxLength() == -1 || schemaColumn.getMaxLength() > 0xA00000) {
                    return new DSSTypeSQLMapping(Type.STRING, 12, "text", new Integer[]{2003, 1, 1111, -16, -1, -9});
                }
                return new DSSTypeSQLMapping(Type.STRING, 12, "varchar(" + schemaColumn.getMaxLength() + ")", new Integer[]{2003, 1, 1111, -16, -1, -9});
            }
            case GEOPOINT: {
                return new DSSTypeSQLMapping(Type.GEOPOINT, 1111, this.useGeography ? "geography" : "geometry", new Integer[]{12, -1, -9});
            }
            case GEOMETRY: {
                return new DSSTypeSQLMapping(Type.GEOMETRY, 1111, this.useGeography ? "geography" : "geometry", new Integer[]{12, -1, -9});
            }
        }
        return super.getSQLType(schemaColumn, dataset);
    }

    @Override
    public void executePostConnectTasks(SQLConnectionProvider.SQLConnectionData connData, SQLConnectionProvider.SQLConnectionWrapper conn) throws SQLException {
        if (connData.getSchemaSearchPath() != null && connData.getSchemaSearchPath().length() > 0) {
            SQLUtils.safeExec(conn, "SET search_path TO " + connData.getSchemaSearchPath());
        }
    }

    @Override
    protected String cast(String expr, Type exprType, Type requestedType, int maxLength) {
        String ret = expr;
        String sqlType = this.getSQLType((Type)requestedType, (int)maxLength, (String)ret).sqlDecl.toUpperCase(Locale.ENGLISH);
        if (requestedType == Type.BOOLEAN && exprType == Type.STRING) {
            return "CASE WHEN (" + expr + ") IS NULL OR CAST(" + expr + " AS VARCHAR(100)) = '' THEN NULL ELSE CAST(" + expr + " AS VARCHAR(100)) ~* '^" + this.booleanTrueValuesRegex + "$' END";
        }
        if (requestedType == Type.STRING && (exprType == Type.GEOMETRY || exprType == Type.GEOPOINT)) {
            return "ST_ASTEXT(" + expr + ")";
        }
        if (requestedType == Type.DATE && exprType == Type.DATEONLY) {
            return "(CAST(" + ret + " AS TIMESTAMP) AT TIME ZONE 'UTC')";
        }
        if (requestedType == Type.DATE && exprType == Type.DATETIMENOTZ) {
            return "(" + ret + " AT TIME ZONE 'UTC')";
        }
        if (sqlType.equals("DOUBLE")) {
            sqlType = "DOUBLE PRECISION";
        }
        return "CAST(" + ret + " AS " + sqlType + ")";
    }

    @Override
    public SchemaColumn fromSQLType(String name, int sqlType, String sqlTypeName, int sqlPrecision, int sqlScale, AbstractSQLDatasetHandler.ReadTemporalMode datetimenotzReadMode, AbstractSQLDatasetHandler.ReadTemporalMode dateonlyReadMode) {
        if ("geometry".equals(sqlTypeName) || "geography".equals(sqlTypeName)) {
            return new SchemaColumn(name, Type.GEOMETRY);
        }
        return super.fromSQLType(name, sqlType, sqlTypeName, sqlPrecision, sqlScale, datetimenotzReadMode, dateonlyReadMode);
    }

    @Override
    public String getValueAsDSSString(ResultSet rs2, int sqlType, int colIdx, SchemaColumn schemaColumn, boolean normalizeDoubles, boolean timestampNoTzAsDate, DateTimeZone assumedTz) throws SQLException {
        switch (sqlType) {
            case 1111: {
                String stringValue = rs2.getString(colIdx);
                if (schemaColumn.getType().isGeo() && stringValue != null) {
                    try {
                        return WKB_READER.read(WKBReader.hexToBytes((String)stringValue)).toText();
                    }
                    catch (Exception e) {
                        logger.warnV((Throwable)e, "Failed to parse WKB geometry: %s", new Object[]{stringValue});
                        return stringValue;
                    }
                }
                return stringValue;
            }
            case -2: {
                return null;
            }
        }
        return super.getValueAsDSSString(rs2, sqlType, colIdx, schemaColumn, normalizeDoubles, timestampNoTzAsDate, assumedTz);
    }

    @Override
    protected void initOperators() {
        super.initOperators();
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.DATE_ADD, QueryUtils.Arity.TERNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                Type dssType;
                this.validateNumberOfParameters(args);
                String datetimeNoTz = this.toSQLNoBrackets(args[0]);
                String addIntLong = this.toSQLNoBrackets(args[1]);
                String unit = this.getParamAs(args[2], String.class);
                Type type = dssType = args[0].outputType != null ? args[0].outputType.dssType : null;
                if (dssType == null) {
                    dssType = Type.DATE;
                }
                if (dssType == Type.DATEONLY) {
                    return "CAST((" + datetimeNoTz + " + " + addIntLong + " * interval '1 " + unit + "') AS DATE)";
                }
                return "(" + datetimeNoTz + " + " + addIntLong + " * interval '1 " + unit + "')";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_AREA, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("ST_AREA(%s::geometry)", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_CENTROID, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("ST_CENTROID(%s::geometry)", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_DISTANCE, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry1 = this.toSQLNoBrackets(args[0]);
                String geometry2 = this.toSQLNoBrackets(args[1]);
                return String.format("ST_DISTANCE(%s::geography, %s::geography)", geometry1, geometry2);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_LENGTH, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("CASE WHEN (ST_GEOMETRYTYPE(%s::geometry)='ST_Polygon' OR ST_GEOMETRYTYPE(%<s::geometry)='ST_MultiPolygon') THEN ST_PERIMETER(%<s::geometry) ELSE ST_LENGTH(%<s::geometry) END", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NOW, "CURRENT_TIMESTAMP", QueryUtils.Arity.NO_ARG){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return "CURRENT_TIMESTAMP";
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.NULL, QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs < 3;
            }

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                if (args.length == 0) {
                    return "NULL";
                }
                Type type = this.getParamAs(args[0], Type.class);
                Integer maxLength = this.getParamAs(args[1], Integer.class);
                return PostgreSQLDialect.this.cast("NULL", null, type, maxLength);
            }
        });
        this.addDistanceBasedOperator(QueryUtils.OperatorType.ST_DWITHIN, "ST_DWITHIN");
        this.addDistanceBasedOperator(QueryUtils.OperatorType.ST_BEYOND, "NOT ST_DWITHIN");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_WITHIN, "ST_WITHIN");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_EQUALS, "ST_EQUALS");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_CONTAINS, "ST_CONTAINS");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_CROSSES, "ST_CROSSES");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_TOUCHES, "ST_TOUCHES");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_DISJOINT, "ST_DISJOINT");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_OVERLAPS, "ST_OVERLAPS");
        this.addGeometryBinaryOperator(QueryUtils.OperatorType.ST_INTERSECTS, "ST_INTERSECTS");
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_SIMPLIFY, QueryUtils.Arity.BINARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                String toleranceDistance = this.toSQLNoBrackets(args[1]);
                return String.format("ST_ASTEXT(ST_SIMPLIFYPRESERVETOPOLOGY(%s::geometry, %s))", geometry, toleranceDistance);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_ENVELOPE, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format("ST_ASTEXT(ST_ENVELOPE(%s::geometry))", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_MAKEVALID, QueryUtils.Arity.UNARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                return String.format(" CASE \n      WHEN (%1$s IS NULL OR %1$s::text = '') THEN ''\n      WHEN ST_ISVALID(%1$s::geometry) THEN ST_ASTEXT(%1$s::geometry)\n      WHEN (ST_ISEMPTY(ST_CollectionExtract(ST_MAKEVALID(%1$s::geometry),3))) THEN ''\n      ELSE (ST_ASTEXT(ST_CollectionExtract(ST_MAKEVALID(%1$s::geometry),3)))\n     END ", geometry);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_BUFFER, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                String distance = this.toSQLNoBrackets(args[1]);
                String quadrantSegment = "8";
                if (args.length == 3) {
                    quadrantSegment = this.toSQLNoBrackets(args[2]);
                }
                return String.format("NULLIF(ST_ASTEXT(ST_BUFFER(%s::geometry,%s,%s)),'POLYGON EMPTY')", geometry, distance, quadrantSegment);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.ST_TRANSFORM, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                String geometry = this.toSQLNoBrackets(args[0]);
                String sourceSRID = this.toSQLNoBrackets(args[1]);
                String targetSRID = this.toSQLNoBrackets(args[2]);
                return String.format("ST_ASTEXT(ST_TRANSFORM(ST_SETSRID(%s::geometry, %s), %s))", geometry, sourceSRID, targetSRID);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.RAND, "RAND", QueryUtils.Arity.NARY){

            @Override
            public boolean checkNumberOfParameters(int nArgs) {
                return nArgs == 0 || nArgs == 2;
            }

            @Override
            public String apply(QueryAst.Expr[] args) throws QueryUtils.SQLGenerationException {
                this.validateNumberOfParameters(args);
                if (args == null || args.length == 0) {
                    return "RANDOM()";
                }
                if (args.length == 2) {
                    String min = "CAST(" + this.toSQLNoBrackets(args[0]) + " AS BIGINT)";
                    String max = "CAST(" + this.toSQLNoBrackets(args[1]) + " AS BIGINT)";
                    return String.format("%1$s + CAST(FLOOR(RANDOM() * (%2$s - %1$s)) AS BIGINT)", min, max);
                }
                return super.apply(args);
            }
        });
        this.addGenericFunction(QueryUtils.OperatorType.REVERSE_STR, "REVERSE", QueryUtils.Arity.UNARY);
        this.addGenericFunction(QueryUtils.OperatorType.CHAR, "CHR", QueryUtils.Arity.UNARY);
        this.initRegexpOperators();
    }

    protected void initRegexpOperators() {
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_REPLACE, "REGEXP_REPLACE", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return PostgreSQLDialect.this.generateRegExpReplace(this, args);
            }
        });
        this.addOperator(new QueryUtils.Function(this, QueryUtils.OperatorType.REGEXP_SUBSTR, "REGEXP_SUBSTR", QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                return PostgreSQLDialect.this.generateRegExpSubstr(this, args);
            }
        });
    }

    private void addDistanceBasedOperator(QueryUtils.OperatorType operator, final String sqlFunction) {
        this.addOperator(new QueryUtils.Function(this, operator, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return String.format("%s(%s::geography, %s::geography, %s)", sqlFunction, this.toSQLNoBrackets(args[0]), this.toSQLNoBrackets(args[1]), this.toSQLNoBrackets(args[2]));
            }
        });
    }

    private void addGeometryBinaryOperator(QueryUtils.OperatorType operator, final String sqlFunction) {
        this.addOperator(new QueryUtils.Function(this, operator, QueryUtils.Arity.NARY){

            @Override
            public String apply(QueryAst.Expr[] args) {
                this.validateNumberOfParameters(args);
                return String.format("%s(%s::geometry, %s::geometry)", sqlFunction, this.set4326IfMissingSRID(args[0]), this.set4326IfMissingSRID(args[1]));
            }

            private String set4326IfMissingSRID(QueryAst.Expr expr) {
                String geomExpr = String.format("%s::geometry", this.toSQLNoBrackets(expr));
                return String.format("ST_SETSRID(%s, COALESCE(NULLIF(ST_SRID(%s), 0), 4326))", geomExpr, geomExpr);
            }
        });
    }

    @Override
    public boolean supportsNamedWindows() {
        return false;
    }

    @Override
    public boolean supportRetrieveTableRowCount() {
        return true;
    }

    @Override
    public boolean requiresStrictTypeComparison() {
        return true;
    }

    @Override
    public String cleanupColumnName(String columnName) {
        return columnName;
    }

    @Override
    public String escapeSchemaOrTableNameForJDBCMetadataQuerying(String identifier) {
        if (identifier == null) {
            return null;
        }
        identifier = identifier.replaceAll("\\\\", "\\\\\\\\");
        return identifier.replace("_", "\\_");
    }

    @Override
    public DatasetRecordCount retrieveTableRowCount(SQLConnectionProvider.SQLConnectionData connectionData, SQLConnectionProvider.SQLConnectionWrapper conn, SQLUtils.SQLTable sqlTable) throws SQLException {
        String tableOid = this.getQuotedTableFullName(sqlTable);
        String query = String.format("SELECT reltuples::bigint FROM pg_class WHERE oid = '%s'::regclass;", tableOid);
        try (PreparedStatement statement = conn.prepareStatement(query);){
            if (statement.execute()) {
                try (ResultSet rs2 = statement.getResultSet();){
                    if (rs2.next()) {
                        DatasetRecordCount datasetRecordCount = DatasetRecordCount.approximate(rs2.getLong(1));
                        return datasetRecordCount;
                    }
                }
            }
            DatasetRecordCount datasetRecordCount = null;
            return datasetRecordCount;
        }
    }

    @Override
    public int getMaxPossibleVarcharLen() {
        return -1;
    }

    @Override
    public String getId() {
        return "PostgreSQL";
    }

    @Override
    public String captureGroup(int group) {
        return "\\" + group;
    }

    @Override
    public SQLDialect.UpsertWriter getUpsertWriter() {
        return new SQLDialect.UpsertWriter(){

            @Override
            public String generate(SQLDialect.UpsertSpec spec) {
                List upsertKeys = spec.keys.stream().collect(Collectors.toList());
                if (spec.scheme != null && spec.scheme.isPartitioned()) {
                    upsertKeys.addAll(spec.scheme.getDimensionNames());
                }
                List keysSql = upsertKeys.stream().map(c2 -> PostgreSQLDialect.this.quoteIdentifier((String)c2)).collect(Collectors.toList());
                List targetFields = spec.columns.stream().map(c2 -> PostgreSQLDialect.this.quoteIdentifier((String)c2)).collect(Collectors.toList());
                ArrayList<String> setCommands = new ArrayList<String>();
                for (String c3 : spec.columns) {
                    setCommands.add(String.format("%s = EXCLUDED.%s", PostgreSQLDialect.this.quoteIdentifier(c3), PostgreSQLDialect.this.quoteIdentifier(c3)));
                }
                if (!spec.sourceSelect.startsWith("SELECT")) {
                    spec.sourceSelect = String.format("SELECT %s FROM %s", targetFields.stream().collect(Collectors.joining(", ")), spec.sourceSelect);
                }
                String indexWhere = "";
                if (spec.scheme != null && spec.scheme.isPartitioned()) {
                    indexWhere = String.format("WHERE %s", spec.targetPartitionFilter.toSQL(PostgreSQLDialect.this));
                }
                return String.format("INSERT INTO %s (%s)\n%s AS \"src\" \nON CONFLICT (%s) %s\nDO UPDATE SET %s", PostgreSQLDialect.this.getQuotedTableFullName(spec.target), targetFields.stream().collect(Collectors.joining(", ")), spec.sourceSelect, keysSql.stream().collect(Collectors.joining(", ")), indexWhere, setCommands.stream().collect(Collectors.joining(", ")));
            }

            @Override
            public boolean usesIndex() {
                return true;
            }

            @Override
            public boolean canUpsertConcurrently() {
                return true;
            }
        };
    }

    @Override
    public SQLDialect.UpdateSelectWriter getUpdateSelectWriter() {
        return new SQLUtils.UpdateFromUpdateSelectWriter(this, false, false);
    }

    @Override
    public SQLDialect.UniqueConstraintWriter getUniqueConstraintWriter() {
        return new SQLDialect.UniqueConstraintWriter(){

            @Override
            public String generateCreate(SQLDialect.UpsertSpec spec) {
                List upsertKeys = spec.keys.stream().collect(Collectors.toList());
                if (spec.scheme != null && spec.scheme.isPartitioned()) {
                    upsertKeys.addAll(spec.scheme.getDimensionNames());
                }
                List targetKeys = upsertKeys.stream().map(k -> String.format("%s", PostgreSQLDialect.this.quoteIdentifier((String)k))).collect(Collectors.toList());
                return String.format("CREATE UNIQUE INDEX %s ON %s (%s)", PostgreSQLDialect.this.quoteIdentifier(spec.index.getTable()), PostgreSQLDialect.this.getQuotedTableFullName(spec.target), targetKeys.stream().collect(Collectors.joining(", ")));
            }

            @Override
            public String generateDrop(SQLDialect.UpsertSpec spec) {
                return String.format("DROP INDEX IF EXISTS %s", PostgreSQLDialect.this.getQuotedTableFullName(spec.index));
            }
        };
    }

    @Override
    public SQLDialect.MaterializedTemporaryTableWriter getMaterializedTemporaryTableWriter() {
        return new SQLUtils.RegularTableMaterializedTemporaryTableWriter(this, true){

            @Override
            protected String generateCTASTemp(String tempFullName, String targetFullName, String fieldsDef) {
                return String.format("CREATE TABLE %s AS SELECT * FROM %s WITH NO DATA", tempFullName, targetFullName);
            }
        };
    }

    @Override
    public String generateTableCommentStatementQuery(DatabaseObjectKey tableKey, String description, InfoMessage.InfoMessages messages) {
        return "COMMENT ON TABLE " + this.getQuotedTableFullName(tableKey.catalog, tableKey.schema, tableKey.name) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(description, tableKey.name, true, messages));
    }

    @Override
    public String generateColumnCommentStatementQuery(DatabaseObjectKey tableKey, SchemaColumn column, InfoMessage.InfoMessages messages) {
        return "COMMENT ON COLUMN " + this.getQuotedColumnFullName(tableKey.catalog, tableKey.schema, tableKey.name, column.getName()) + " IS " + this.quoteDescriptionOrEmpty(this.truncateDescription(column.comment, column.getName(), false, messages)) + ";";
    }

    @Override
    public boolean supportsWriteSQLComment() {
        return true;
    }

    public static class PostgreSQLDatasetConfig
    extends AbstractSQLDatasetHandler.AbstractSQLConfig {
        private static final long serialVersionUID = 1L;
        public WriteWithCopyBadDataBehavior writeWithCopyBadDataBehavior = WriteWithCopyBadDataBehavior.NOVERIFY_ERROR;

        public static enum WriteWithCopyBadDataBehavior {
            NOVERIFY_ERROR,
            ERROR,
            DISCARD_CELL;

        }
    }
}

