/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.sql.queries;

import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.sql.SQLUtils;
import com.dataiku.dip.sql.queries.SQLQueries;
import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.sql.Statement;

public abstract class AbstractQueryBuilder {
    static final String EMPTY_STRING = "";
    protected SQLDialect dialect;
    protected final SQLUtils.SQLTable table;
    protected final SQLQueries queries = new SQLQueries();

    AbstractQueryBuilder(SQLUtils.SQLTable table) {
        this.table = table;
    }

    public String toSQL(SQLDialect dialect) {
        return this.initAndBuildSQLQueries(dialect).getSingleQuery();
    }

    public void execute(Statement statement, SQLDialect dialect) throws SQLException {
        this.initAndBuildSQLQueries(dialect).execute(statement);
    }

    abstract void buildSQLQueries();

    private SQLQueries initAndBuildSQLQueries(SQLDialect dialect) {
        this.dialect = dialect;
        this.assertBuilderIsValid();
        this.buildSQLQueries();
        return this.queries;
    }

    protected void assertBuilderIsValid() {
        Preconditions.checkNotNull((Object)this.table, (Object)"A table be specified.");
        Preconditions.checkNotNull((Object)this.dialect, (String)"The dialect must be specified for table '%s'.", (Object)this.table.getTable());
    }
}

