/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.theming.model;

import com.dataiku.dip.pivot.frontend.color.Color;
import com.dataiku.dip.theming.model.ThemeColors;
import com.dataiku.j2ts.annotations.UIModel;
import com.dataiku.j2ts.annotations.UINullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@UIModel
public class ThemePalette {
    public String id = "default_theme";
    public String name = "Theme default";
    public String category = "BUILT_IN";
    public String[] colors;
    @UINullable
    public String[] sample;
    @UINullable
    public Boolean isCustom = false;
    @UINullable
    public Boolean createPairs = false;

    public ThemePalette(@Nullable String id, @Nullable String name, @Nullable String category, String[] colors, String[] sample, @Nullable Boolean isCustom, @Nullable Boolean createPairs) {
        if (id != null) {
            this.id = id;
        }
        if (name != null) {
            this.name = name;
        }
        if (category != null) {
            this.category = category;
        }
        this.colors = colors;
        this.sample = sample;
        this.isCustom = isCustom;
        this.createPairs = createPairs;
    }

    public static String[] createSampleFrom(String[] themePaletteColors) {
        return Arrays.copyOf(themePaletteColors, Math.min(5, themePaletteColors.length));
    }

    public static ThemePalette createWithThemeColors(ThemePaletteType paletteType, String id, String name, String category, ThemeColors.ThemeColorId themeColorId, ThemeColors themeColors, Boolean createPairs) {
        String[] themePaletteColors = ThemePalette.getThemeColors(paletteType, themeColorId, themeColors);
        String[] sample = paletteType == ThemePaletteType.DISCRETE ? ThemePalette.createSampleFrom(themePaletteColors) : null;
        return new ThemePaletteBuilder().setId(id).setName(name).setCategory(category).setColors(themePaletteColors).setSample(sample).setIsCustom(false).setCreatePairs(createPairs).build();
    }

    public static String[] getThemeColors(ThemePaletteType themePaletteType, ThemeColors.ThemeColorId themeColorId, ThemeColors themeColors) {
        return switch (themePaletteType) {
            case ThemePaletteType.DISCRETE -> ThemePalette.getThemeDiscretePaletteColors(themeColorId, themeColors);
            case ThemePaletteType.CONTINUOUS -> ThemePalette.getThemeContinuousPaletteColors(themeColorId, themeColors);
            case ThemePaletteType.DIVERGING -> ThemePalette.getThemeDivergingPaletteColors(themeColorId, themeColors);
            default -> throw new IllegalArgumentException("Unsupported palette type: " + String.valueOf((Object)themePaletteType));
        };
    }

    public static String[] getThemeDiscretePaletteColors(ThemeColors.ThemeColorId themeColorId, ThemeColors themeColors) {
        return themeColors.getThemeColors(themeColorId);
    }

    public static String[] getThemeContinuousPaletteColors(ThemeColors.ThemeColorId themeColorId, ThemeColors themeColors) {
        String[] stringArray;
        String[] colors = themeColors.getThemeColors(themeColorId);
        Color color = Color.fromHTML(colors[0]);
        double luminance = Color.getLuminance(color);
        if (luminance < 0.5) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = Color.brighten(new Color.BrightenParams(colors[0], 20.0f, 0.9f));
            stringArray = stringArray2;
            stringArray2[1] = colors[0];
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = colors[0];
            stringArray = stringArray3;
            stringArray3[1] = Color.darken(new Color.DarkenParams(colors[0], 20.0f, 0.1f));
        }
        return stringArray;
    }

    public static String[] getThemeDivergingPaletteColors(ThemeColors.ThemeColorId themeColorId, ThemeColors themeColors) {
        String[] colors = themeColors.getThemeColors(themeColorId);
        return new String[]{colors[0], "#FFFFFF", colors[1]};
    }

    public ThemePalette createRevThemePalette() {
        String[] revThemePaletteColors = (String[])Arrays.stream(this.colors).collect(Collectors.collectingAndThen(Collectors.toList(), colorsList -> {
            Collections.reverse(colorsList);
            return colorsList.stream();
        })).toArray(String[]::new);
        return new ThemePaletteBuilder().setId(this.id + "_rev").setName(this.name + " (rev)").setCategory(this.category).setColors(revThemePaletteColors).setSample(ThemePalette.createSampleFrom(revThemePaletteColors)).setIsCustom(this.isCustom).build();
    }

    public static enum ThemePaletteType {
        DISCRETE,
        CONTINUOUS,
        DIVERGING;

    }

    public static class ThemePaletteBuilder {
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String category;
        private String[] colors;
        private String[] sample;
        private boolean isCustom = false;
        private boolean createPairs = false;

        public ThemePaletteBuilder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public ThemePaletteBuilder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public ThemePaletteBuilder setCategory(@Nullable String category) {
            this.category = category;
            return this;
        }

        public ThemePaletteBuilder setColors(String[] colors) {
            this.colors = colors;
            return this;
        }

        public ThemePaletteBuilder setSample(String[] sample) {
            this.sample = sample;
            return this;
        }

        public ThemePaletteBuilder setIsCustom(boolean isCustom) {
            this.isCustom = isCustom;
            return this;
        }

        public ThemePaletteBuilder setCreatePairs(boolean createPairs) {
            this.createPairs = createPairs;
            return this;
        }

        public ThemePalette build() {
            return new ThemePalette(this.id, this.name, this.category, this.colors, this.sample, this.isCustom, this.createPairs);
        }
    }
}

