/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps;

import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppRegistry;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendsManager;
import java.io.File;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class WebAppHandler {
    @Autowired
    protected WebAppBackendsManager backendsManager;
    protected WebApp webapp;

    public static WebAppHandler buildHandler(WebApp webapp) {
        return WebAppRegistry.getMeta(webapp.type).buildHandler(webapp);
    }

    public abstract void initWebApp() throws IOException;

    public abstract void initCustomWebApp() throws IOException;

    public abstract void initWebAppTemplate(String var1, File var2) throws IOException;

    public abstract void readCodeFiles();

    public abstract void writeCodeFiles() throws IOException;

    public abstract void deleteCodeFiles() throws IOException;

    public boolean backendReady(WebAppBackendInstance.BackendState currentState, int requestTimeout) throws IOException {
        try {
            String html = this.getHtml(requestTimeout);
            if (html == null) {
                return false;
            }
            return !html.startsWith("Failed to get html for backend: ");
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Web app backend does not seem to be running", e);
        }
    }

    public String getHtml(int requestTimeout) throws IOException {
        WebAppBackend backend = this.backendsManager.getBackendOrNull(this.webapp.projectKey, this.webapp.id);
        if (backend == null) {
            throw ErrorContext.iaef((String)"Backend not registered for webapp %s.%s", (Object)this.webapp.projectKey, (Object[])new Object[]{this.webapp.id});
        }
        return backend.probeBackend((int)requestTimeout).html;
    }
}

