/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend.exposition;

import com.dataiku.dip.exposition.ExpositionHandler;
import com.dataiku.dip.utils.DKUtils;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import java.io.IOException;
import org.apache.log4j.Logger;

public class WebAppExpositionHandlerThread
extends Thread {
    private final WebApp webApp;
    private final WebAppBackend webAppBackend;
    private final WebAppBackendInstance webAppBackendInstance;
    private final ExpositionHandler handler;
    private final DKUtils.LineSubscriptionAttacher mainLog;
    private final DKUtils.SmartLogTailBuilder smartLogTailBuilder;
    private volatile boolean hasStarted;
    private static Logger logger = Logger.getLogger((String)"dip.webapp.exposition.thread");

    public WebAppExpositionHandlerThread(WebApp webApp, WebAppBackend backend, WebAppBackendInstance instance, ExpositionHandler handler, DKUtils.LineSubscriptionAttacher mainLog, DKUtils.SmartLogTailBuilder smartLogTailBuilder) {
        this.webApp = webApp;
        this.webAppBackend = backend;
        this.webAppBackendInstance = instance;
        this.handler = handler;
        this.mainLog = mainLog;
        this.smartLogTailBuilder = smartLogTailBuilder;
    }

    @Override
    public void run() {
        try {
            logger.info((Object)("Starting webapp exposition: " + this.handler.getClass().getCanonicalName()));
            this.handler.start(this.mainLog, this.smartLogTailBuilder);
            logger.info((Object)"Waiting for webapp exposition to start");
            this.handler.waitReady(this.mainLog, this.smartLogTailBuilder);
            logger.info((Object)"Webapp exposition has started, waiting for backend to be ready");
            try {
                long start = System.currentTimeMillis();
                WebAppHandler wah = WebAppHandler.buildHandler(this.webApp);
                while (System.currentTimeMillis() - start < 3600000L) {
                    this.webAppBackendInstance.checkStartFailure();
                    try {
                        WebAppBackendInstance.BackendState backendState = this.webAppBackend.getBackendState(this.webAppBackendInstance, false);
                        if (wah.backendReady(backendState, 0)) {
                            logger.info((Object)"Backend is ready, exposition job is done");
                            this.hasStarted = true;
                            return;
                        }
                    }
                    catch (IOException e) {
                        logger.info((Object)"Failed to contact webapp backend, wait...");
                    }
                    Thread.sleep(300L);
                }
                logger.warn((Object)"Backend still not ready, failing the exposition startup");
                throw new IOException("Backend still not ready after enough time, check logs");
            }
            catch (Exception e) {
                logger.warn((Object)"Failure while waiting for backend to be ready, failing the exposition startup", (Throwable)e);
                throw e;
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed to wait for exposition start", (Throwable)e);
            return;
        }
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public void kill() {
        this.interrupt();
        this.handler.cleanup();
    }
}

