/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.dash;

import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.coremodel.DkuComponentMetadataWithCategory;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.recipes.MetaWithSelectableCodeEnv;
import com.dataiku.dip.recipes.ParamsWithSelectableCodeEnv;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.WebAppHandler;
import com.dataiku.dip.webapps.WebAppMeta;
import com.dataiku.dip.webapps.WebAppTemplate;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.backend.WebAppBackendRunner;
import com.dataiku.dip.webapps.dash.CustomDashWebAppHandler;
import com.dataiku.dip.webapps.dash.DashWebAppHandler;
import com.dataiku.dip.webapps.dash.backend.DashWebAppBackendRunner;
import com.dataiku.dip.webapps.plugins.WebAppDesc;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DashWebAppMeta
implements WebAppMeta,
MetaWithSelectableCodeEnv {
    public static final String TYPE = "DASH";
    private static final WebAppDesc desc = DashWebAppMeta.makeDesc();
    public static final DashWebAppMeta META = new DashWebAppMeta();

    @Override
    public Class<? extends WebApp.WebAppParams> getParamsClass() {
        return DashWebAppParams.class;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isCustomWebApp() {
        return false;
    }

    @Override
    public WebAppBackendRunner buildRunner(WebApp webApp, WebAppBackend webAppBackend, JsonObject variables, AuthCtx user, WebAppBackendInstance webAppBackendInstance) {
        return new DashWebAppBackendRunner(webApp, webAppBackend, variables, user, webAppBackendInstance);
    }

    @Override
    public WebAppHandler buildHandler(WebApp webapp) {
        return new DashWebAppHandler(webapp);
    }

    @Override
    public WebAppHandler buildCustomHandler(WebApp webApp, File webappFolder) {
        return new CustomDashWebAppHandler(webApp, webappFolder);
    }

    @Override
    public CodeEnvModel.EnvLang getEnvLang() {
        return CodeEnvModel.EnvLang.PYTHON;
    }

    private static WebAppDesc makeDesc() {
        String shortDesc = "Use <a target=\"_blank\" rel=\"noopener noreferrer\" href=\"https://plotly.com/dash/\">Dash</a> to generate interactive visualizations using only Python";
        DkuComponentMetadataWithCategory data = new DkuComponentMetadataWithCategory("Dash", shortDesc, "dku-icon-plotly-48", null);
        return new WebAppDesc(TYPE, data);
    }

    @Override
    public WebAppDesc getWebAppDesc() {
        return desc;
    }

    @Override
    public List<Object> getHashElements(WebApp webApp) {
        DashWebAppParams params = webApp.getParamsAs(DashWebAppParams.class);
        return params.getHashElements();
    }

    public static class DashWebAppParams
    extends WebApp.WebAppParams
    implements ParamsWithSelectableCodeEnv {
        @JSON.FileTransient
        public String python;
        public boolean autoStartBackend;
        public CodeEnvSelection envSelection = new CodeEnvSelection();
        public int nbProcesses = 0;
        public boolean serveLocally = true;
        public boolean backendAPIAccessEnabled;

        @Override
        public boolean isBackendEnabled() {
            return true;
        }

        @Override
        public boolean isAutoStartBackend() {
            return this.autoStartBackend;
        }

        @Override
        public JsonObject getSensitiveSettings(AuthCtx authCtx) throws IOException, DKUSecurityException {
            Preconditions.checkNotNull((Object)this.python);
            JsonObject ret = super.getSensitiveSettings(authCtx);
            ret.addProperty("type", DashWebAppMeta.TYPE);
            ret.addProperty("python", this.python);
            return ret;
        }

        @Override
        public boolean isLoadingPythonLibraries() {
            return true;
        }

        @Override
        public boolean isLoadingRLibraries() {
            return false;
        }

        @Override
        public CodeEnvSelection getCodeEnvSelection() {
            return this.envSelection;
        }

        @Override
        public void setCodeEnvSelection(CodeEnvSelection envSelection) {
            this.envSelection = envSelection;
        }

        @Override
        public List<CodeEnvModel.CodeEnvUsage> collectCodeEnvUsage(TaggableObjectsService.TaggableObject object) {
            ArrayList usages = Lists.newArrayList();
            if (this.envSelection.envMode == CodeEnvSelection.EnvMode.EXPLICIT_ENV) {
                usages.add(new CodeEnvModel.CodeEnvUsage(CodeEnvModel.EnvLang.PYTHON, this.envSelection.envName, CodeEnvModel.EnvUsage.WEBAPP, object.getProjectKey(), object.getId()));
            }
            return usages;
        }

        @Override
        public List<Object> getHashElements() {
            return Lists.newArrayList((Object[])new Object[]{this.forceAuthentication, this.python, this.envSelection, this.nbProcesses, this.serveLocally});
        }

        @Override
        public void setCodeForFile(String code, String filename, String filenameExtension) {
            this.python = code;
        }
    }

    public static class DashWebAppTemplateMeta
    extends WebAppTemplate {
    }
}

