/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.strings;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;
import org.apache.commons.lang.WordUtils;

public class ToTitlecase
implements Function {
    private static final char[] delimiters = new char[]{' ', '\t', '\r', '\n', '.'};

    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1 && args[0] != null) {
            Object o = args[0];
            String s = o instanceof String ? (String)o : o.toString();
            return WordUtils.capitalizeFully((String)s, (char[])delimiters);
        }
        if (args.length == 2 && args[0] != null && args[1] != null) {
            Object o = args[0];
            String s = o instanceof String ? (String)o : o.toString();
            o = args[1];
            String delims = o instanceof String ? (String)o : o.toString();
            return WordUtils.capitalizeFully((String)s, (char[])delims.toCharArray());
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a one or two strings");
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.ToTitlecase.DOCUMENTATION", "Converts a string to titlecase.").withParams("string s").withReturns("string").withCategory("GREL.FUNCTIONS.CATEGORY.STRING", "String functions").withExample(Example.with("\"hello world\"").returns("\"Hello World\""));
    }
}

