/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.grel;

import com.google.refine.expr.Evaluable;
import com.google.refine.expr.ParsingException;
import com.google.refine.grel.Control;
import com.google.refine.grel.ControlFunctionRegistry;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import com.google.refine.grel.Scanner;
import com.google.refine.grel.ast.ControlCallExpr;
import com.google.refine.grel.ast.FieldAccessorExpr;
import com.google.refine.grel.ast.FunctionCallExpr;
import com.google.refine.grel.ast.LiteralExpr;
import com.google.refine.grel.ast.OperatorCallExpr;
import com.google.refine.grel.ast.VariableExpr;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;

public class Parser {
    protected Scanner _scanner;
    protected Scanner.Token _token;
    protected Evaluable _root;
    protected ControlFunctionRegistry _registry;

    public Parser(String s) throws ParsingException {
        this(s, 0, s.length());
    }

    public Parser(String s, ControlFunctionRegistry registry) throws ParsingException {
        this(s, 0, s.length(), registry);
    }

    public Parser(String s, int from, int to) throws ParsingException {
        this(s, from, to, GrelControlFunctionRegistry.getInstance());
    }

    public Parser(String s, int from, int to, ControlFunctionRegistry registry) throws ParsingException {
        this._registry = registry;
        this._scanner = new Scanner(s, from, to);
        this._token = this._scanner.next(true);
        this._root = this.parseExpressionRoot();
    }

    public Evaluable getExpression() {
        return this._root;
    }

    protected void next(boolean regexPossible) {
        this._token = this._scanner.next(regexPossible);
    }

    protected ParsingException makeException(String desc) {
        int index = this._token != null ? this._token.start : this._scanner.getIndex();
        return new ParsingException(desc + " (Parsing error at offset " + index + ")");
    }

    protected Evaluable parseExpressionRoot() throws ParsingException {
        Evaluable expr = this.parseBooleanExpression();
        if (this._token != null && this._token.type == Scanner.TokenType.Delimiter && this.isOneOf(")", "]", ",")) {
            throw this.makeException("Unexpected '" + this._token.text + "'");
        }
        return expr;
    }

    protected Evaluable parseBooleanExpression() throws ParsingException {
        Evaluable expr = this.parseBooleanTerm();
        while (this._token != null && this._token.type == Scanner.TokenType.Operator && this._token.text.equals("||")) {
            String op = this._token.text;
            this.next(true);
            Evaluable expr2 = this.parseBooleanTerm();
            expr = new OperatorCallExpr(new Evaluable[]{expr, expr2}, op);
        }
        return expr;
    }

    protected Evaluable parseBooleanTerm() throws ParsingException {
        Evaluable expr = this.parseBooleanFactor();
        while (this._token != null && this._token.type == Scanner.TokenType.Operator && this._token.text.equals("&&")) {
            String op = this._token.text;
            this.next(true);
            Evaluable expr2 = this.parseBooleanFactor();
            expr = new OperatorCallExpr(new Evaluable[]{expr, expr2}, op);
        }
        return expr;
    }

    protected Evaluable parseBooleanFactor() throws ParsingException {
        if (this._token != null && this._token.type == Scanner.TokenType.Operator && "!".equals(this._token.text)) {
            this.next(false);
            Evaluable expr = this.parseExpression();
            return new OperatorCallExpr(new Evaluable[]{expr}, "!");
        }
        return this.parseExpression();
    }

    protected Evaluable parseExpression() throws ParsingException {
        Evaluable sub = this.parseSubExpression();
        while (this._token != null && this._token.type == Scanner.TokenType.Operator && this.isOneOf("<", "<=", ">", ">=", "==", "!=")) {
            String op = this._token.text;
            this.next(true);
            Evaluable sub2 = this.parseSubExpression();
            sub = new OperatorCallExpr(new Evaluable[]{sub, sub2}, op);
        }
        return sub;
    }

    protected Evaluable parseSubExpression() throws ParsingException {
        Evaluable sub = this.parseTerm();
        this.assertOperatorOrDelimiter();
        while (this._token != null && this._token.type == Scanner.TokenType.Operator && this.isOneOf("+", "-")) {
            String op = this._token.text;
            this.next(true);
            Evaluable sub2 = this.parseTerm();
            sub = new OperatorCallExpr(new Evaluable[]{sub, sub2}, op);
        }
        return sub;
    }

    protected Evaluable parseTerm() throws ParsingException {
        Evaluable factor = this.parseFactor();
        this.assertOperatorOrDelimiter();
        while (this._token != null && this._token.type == Scanner.TokenType.Operator && (this._token.text.equals("*") || this._token.text.equals("/") || this._token.text.equals("//") || this._token.text.equals("%"))) {
            String op = this._token.text;
            this.next(true);
            Evaluable factor2 = this.parseFactor();
            factor = new OperatorCallExpr(new Evaluable[]{factor, factor2}, op);
        }
        return factor;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Evaluable parseFactor() throws ParsingException {
        void var1_12;
        List<Evaluable> args;
        Function f;
        if (this._token == null) {
            throw this.makeException("Unexpected end of expression");
        }
        Object var1_1 = null;
        if (this._token.type == Scanner.TokenType.String) {
            LiteralExpr literalExpr = new LiteralExpr(this._token.text);
            this.next(false);
        } else if (this._token.type == Scanner.TokenType.Regex) {
            Scanner.RegexToken t = (Scanner.RegexToken)this._token;
            try {
                Pattern pattern = Pattern.compile(this._token.text, t.caseInsensitive ? 2 : 0);
                LiteralExpr literalExpr = new LiteralExpr(pattern);
                this.next(false);
            }
            catch (Exception e) {
                throw this.makeException("Bad regular expression (" + e.getMessage() + ")");
            }
        } else if (this._token.type == Scanner.TokenType.Number) {
            LiteralExpr literalExpr = new LiteralExpr(((Scanner.NumberToken)this._token).value);
            this.next(false);
        } else if (this._token.type == Scanner.TokenType.Operator && this._token.text.equals("-")) {
            this.next(true);
            if (this._token == null || this._token.type != Scanner.TokenType.Number) throw this.makeException("Bad negative number");
            Number n = ((Scanner.NumberToken)this._token).value;
            LiteralExpr literalExpr = new LiteralExpr(n instanceof Long ? (double)(-n.longValue()) : -n.doubleValue());
            this.next(false);
        } else if (this._token.type == Scanner.TokenType.Identifier) {
            String text = this._token.text;
            this.next(false);
            if (this._token == null || this._token.type != Scanner.TokenType.Delimiter || !this._token.text.equals("(")) {
                Evaluable evaluable = "null".equals(text) ? new LiteralExpr(null) : new VariableExpr(text);
            } else {
                f = this._registry.getFunction(text);
                Control c2 = this._registry.getControl(text);
                if (f == null && c2 == null) {
                    throw this.makeException("Unknown function '" + text + "'");
                }
                this.next(true);
                List<Evaluable> args2 = this.parseExpressionList(")");
                Evaluable[] argsA = this.makeArray(args2);
                String errorMessage = c2 != null ? c2.checkArguments(argsA) : f.checkArguments(argsA);
                if (errorMessage != null) {
                    throw this.makeException(errorMessage);
                }
                if (c2 != null) {
                    ControlCallExpr controlCallExpr = new ControlCallExpr(argsA, c2);
                } else {
                    FunctionCallExpr functionCallExpr = new FunctionCallExpr(argsA, f);
                }
            }
        } else if (this._token.type == Scanner.TokenType.Delimiter && this._token.text.equals("(")) {
            this.next(true);
            Evaluable evaluable = this.parseBooleanExpression();
            if (this._token == null || this._token.type != Scanner.TokenType.Delimiter || !this._token.text.equals(")")) throw this.makeException("Missing ')'");
            this.next(false);
        } else {
            if (this._token.type != Scanner.TokenType.Delimiter || !this._token.text.equals("[")) throw this.makeException("Missing number, string, identifier, regex or parenthesized expression");
            this.next(true);
            args = this.parseExpressionList("]");
            FunctionCallExpr functionCallExpr = new FunctionCallExpr(this.makeArray(args), this._registry.getFunction("argsToArray"));
        }
        while (this._token != null) {
            if (this._token.type == Scanner.TokenType.Operator && this._token.text.equals(".")) {
                this.next(false);
                if (this._token == null || this._token.type != Scanner.TokenType.Identifier) {
                    throw this.makeException("Missing function name");
                }
                String identifier = this._token.text;
                this.next(false);
                if (this._token != null && this._token.type == Scanner.TokenType.Delimiter && this._token.text.equals("(")) {
                    this.next(true);
                    f = this._registry.getFunction(identifier);
                    if (f == null) {
                        throw this.makeException("Unknown function '" + identifier + "'");
                    }
                    List<Evaluable> args3 = this.parseExpressionList(")");
                    args3.add(0, (Evaluable)var1_12);
                    FunctionCallExpr functionCallExpr = new FunctionCallExpr(this.makeArray(args3), f);
                    continue;
                }
                FieldAccessorExpr fieldAccessorExpr = new FieldAccessorExpr((Evaluable)var1_12, identifier);
                continue;
            }
            if (this._token.type == Scanner.TokenType.Delimiter && this._token.text.equals("(")) {
                throw this.makeException("Unexpected '('");
            }
            if (this._token.type != Scanner.TokenType.Delimiter || !this._token.text.equals("[")) return var1_12;
            this.next(true);
            args = this.parseExpressionList("]");
            args.add(0, (Evaluable)var1_12);
            f = this._registry.getFunction("get");
            FunctionCallExpr functionCallExpr = new FunctionCallExpr(this.makeArray(args), f);
        }
        return var1_12;
    }

    protected List<Evaluable> parseExpressionList(String closingDelimiter) throws ParsingException {
        LinkedList<Evaluable> l = new LinkedList<Evaluable>();
        if (!(this._token == null || this._token.type == Scanner.TokenType.Delimiter && this._token.text.equals(closingDelimiter))) {
            while (this._token != null) {
                Evaluable eval = this.parseBooleanExpression();
                l.add(eval);
                if (this._token == null || this._token.type != Scanner.TokenType.Delimiter || !this._token.text.equals(",")) break;
                this.next(true);
            }
        }
        if (this._token == null || this._token.type != Scanner.TokenType.Delimiter || !this._token.text.equals(closingDelimiter)) {
            throw this.makeException("Missing '" + closingDelimiter + "'");
        }
        this.next(false);
        return l;
    }

    protected Evaluable[] makeArray(List<Evaluable> l) {
        Evaluable[] a = new Evaluable[l.size()];
        l.toArray(a);
        return a;
    }

    protected void assertOperatorOrDelimiter() throws ParsingException {
        if (this._token == null || this._token.type == Scanner.TokenType.Operator || this._token.type == Scanner.TokenType.Delimiter) {
            return;
        }
        String errorMessage = "Unexpected '" + this._token.text + "'";
        HashMap<String, String> suggestedOperators = new HashMap<String, String>();
        suggestedOperators.put("or", "||");
        suggestedOperators.put("|", "||");
        suggestedOperators.put("and", "&&");
        suggestedOperators.put("&", "&&");
        suggestedOperators.put("=", "==");
        if (suggestedOperators.containsKey(this._token.text.toLowerCase())) {
            errorMessage = errorMessage + ". Did you mean '" + (String)suggestedOperators.get(this._token.text.toLowerCase()) + "'?";
        }
        throw this.makeException(errorMessage);
    }

    protected boolean isOneOf(String ... tokens) {
        return Parser.tokenIsOneOf(this._token.text, tokens);
    }

    public static boolean tokenIsOneOf(String tokenToIdentify, String ... tokens) {
        if (tokenToIdentify == null || tokens == null) {
            return false;
        }
        for (String token : tokens) {
            if (!tokenToIdentify.equals(token)) continue;
            return true;
        }
        return false;
    }
}

