/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines.overrides;

import com.dataiku.scoring.Try;
import com.dataiku.scoring.pipelines.OverrideInfo;
import com.dataiku.scoring.pipelines.Result;
import com.dataiku.scoring.pipelines.overrides.OverridesOutcomeComputer;
import com.dataiku.scoring.util.RawObservation;
import java.io.Serializable;

public abstract class OverridesLayerBase<T extends Result<?>>
implements Serializable {
    protected boolean initialized = false;
    private final OverridesOutcomeComputer<RawObservation> outcomeComputer;

    OverridesLayerBase(OverridesOutcomeComputer<RawObservation> outcomeComputer) {
        this.outcomeComputer = outcomeComputer;
    }

    public Try<T> apply(RawObservation obs, T rawResult) {
        T result;
        this.checkInitialized();
        this.prepareRowForOverride(obs, rawResult);
        OverridesOutcomeComputer.OutcomeCandidate<RawObservation> candidate = this.outcomeComputer.getOutcomeCandidate(obs);
        if (candidate != null) {
            result = this.applyOverride(candidate, rawResult);
        } else {
            result = rawResult;
            ((Result)result).setOverrideInfo(OverrideInfo.noMatch());
        }
        return Try.success(result);
    }

    public void init() {
        this.outcomeComputer.init();
        this.initialized = true;
    }

    abstract void prepareRowForOverride(RawObservation var1, T var2);

    abstract T applyOverride(OverridesOutcomeComputer.OutcomeCandidate<RawObservation> var1, T var2);

    protected void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Overrides layer not initialized");
        }
    }
}

