/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.waiters;

import com.dataiku.dss.legacy.aws.com.amazonaws.annotation.SdkInternalApi;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.waiters.AlarmExists;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.waiters.CompositeAlarmExists;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.cloudwatch.waiters.DescribeAlarmsFunction;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.FixedDelayStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.PollingStrategy;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.Waiter;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterBuilder;
import com.dataiku.dss.legacy.aws.com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonCloudWatchWaiters {
    private final AmazonCloudWatch client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonCloudWatchWaiters");

    @SdkInternalApi
    public AmazonCloudWatchWaiters(AmazonCloudWatch client) {
        this.client = client;
    }

    public Waiter<DescribeAlarmsRequest> alarmExists() {
        return new WaiterBuilder<DescribeAlarmsRequest, DescribeAlarmsResult>().withSdkFunction(new DescribeAlarmsFunction(this.client)).withAcceptors(new AlarmExists.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAlarmsRequest> compositeAlarmExists() {
        return new WaiterBuilder<DescribeAlarmsRequest, DescribeAlarmsResult>().withSdkFunction(new DescribeAlarmsFunction(this.client)).withAcceptors(new CompositeAlarmExists.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

