/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.reports;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKUDateUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.Pair;
import com.dataiku.j2ts.annotations.UIModel;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ReportsManagementService {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.reports");

    private File getReportsFile() {
        return DKUApp.getFile("caches", "reports.json");
    }

    private File getReportDataFile(String reportId) {
        return DKUApp.getFile("caches", "reports", reportId + ".json");
    }

    private void writeReadyData(ReadyReportsFile data) throws IOException {
        assert (Thread.holdsLock(this));
        File readyReportsFile = this.getReportsFile();
        JSON.prettyToFile((Object)data, (File)readyReportsFile);
    }

    private ReadyReportsFile readReadyData() throws IOException {
        assert (Thread.holdsLock(this));
        File readyReportsFile = this.getReportsFile();
        if (readyReportsFile.isFile()) {
            return (ReadyReportsFile)JSON.parseFile((File)readyReportsFile, ReadyReportsFile.class);
        }
        return new ReadyReportsFile();
    }

    private void writeReportData(ReadyReport reportData) throws IOException {
        assert (Thread.holdsLock(this));
        File reportDataFile = this.getReportDataFile(reportData.reportId);
        JSON.prettyToFile((Object)reportData, (File)reportDataFile);
    }

    private ReadyReport readReportData(String reportId) throws IOException {
        assert (Thread.holdsLock(this));
        File reportDataFile = this.getReportDataFile(reportId);
        if (reportDataFile.isFile()) {
            return (ReadyReport)JSON.parseFile((File)reportDataFile, ReadyReport.class);
        }
        return null;
    }

    private static boolean isLowPriority(String reportId) {
        return reportId.startsWith("project-usage-summary") || reportId.startsWith("workspace-usage-summary");
    }

    public synchronized ReadyReport popNextReport() throws IOException {
        ReadyReportsFile data = this.readReadyData();
        List readyToSend = data.ready.keySet().stream().map(k -> new Pair(k, (Object)data.lastSends.getOrDefault(k, 0L))).collect(Collectors.toList());
        long minAge = DKUApp.getParams().getLongParam("dip.reports.minAgeToSend", 604800000L);
        List oldEnough = readyToSend.stream().filter(e -> System.currentTimeMillis() - (Long)e.second >= minAge).collect(Collectors.toList());
        long highPrioCount = oldEnough.stream().filter(e -> !ReportsManagementService.isLowPriority((String)e.first)).count();
        logger.infoV("Reports stats: readyToSend=%d oldEnoughToSend=%d highPriorityToSend=%d", new Object[]{readyToSend.size(), oldEnough.size(), highPrioCount});
        Pair selected = oldEnough.stream().min((e1, e2) -> {
            if (ReportsManagementService.isLowPriority((String)e1.first) != ReportsManagementService.isLowPriority((String)e2.first)) {
                return ReportsManagementService.isLowPriority((String)e2.first) ? -1 : 1;
            }
            return Long.compare((Long)e1.second, (Long)e2.second);
        }).orElse(null);
        if (selected == null) {
            logger.info((Object)"No report is selected to send, not sending anything");
            return null;
        }
        if (ReportsManagementService.isLowPriority((String)selected.first) && highPrioCount > 0L) {
            logger.warn((Object)"Sending a low-priority report whereas there are high-priority ones?!");
        }
        if (System.currentTimeMillis() - (Long)selected.second < minAge) {
            logger.warn((Object)"Selected a too-recent report?!");
        }
        String selectedKey = (String)selected.first;
        logger.info((Object)("Selected report for send: " + selectedKey + ", last send=" + String.valueOf(selected.second)));
        ReadyReportInfo info = data.ready.remove(selectedKey);
        logger.info((Object)("Sending " + JSON.json((Object)info)));
        try {
            ReadyReport ret = this.readReportData(selectedKey);
            if (ret == null) {
                logger.warn((Object)"Report referenced in list, but file was deleted");
                return null;
            }
            this.deleteKeyFromReadyReportsFile(data, selectedKey);
            return ret;
        }
        catch (JsonParseException e3) {
            String reportDataFileContent = DKUFileUtils.fileToString((File)this.getReportDataFile(selectedKey));
            this.deleteKeyFromReadyReportsFile(data, selectedKey);
            throw new RuntimeException("Unable to read report", new RuntimeException("Invalid JSON report file: " + reportDataFileContent, e3));
        }
    }

    private synchronized void deleteKeyFromReadyReportsFile(ReadyReportsFile data, String oldestKey) throws IOException {
        data.lastSends.put(oldestKey, System.currentTimeMillis());
        DKUFileUtils.delete((File)this.getReportDataFile(oldestKey));
        this.writeReadyData(data);
    }

    public synchronized void storeReports(List<ReadyReport> reports) throws IOException {
        ReadyReportsFile data = this.readReadyData();
        for (ReadyReport rep : reports) {
            data.ready.put(rep.reportId, rep.asInfo());
            this.writeReportData(rep);
        }
        this.writeReadyData(data);
    }

    public static class ReadyReportsFile {
        public Map<String, ReadyReportInfo> ready = new HashMap<String, ReadyReportInfo>();
        public Map<String, Long> lastSends = new HashMap<String, Long>();
    }

    @UIModel
    public static class ReadyReport
    extends ReadyReportInfo {
        public final JsonObject reportData;

        private ReadyReport(String builtOn, String reportType, String reportId, String reportPublicId, JsonObject reportData) {
            super(builtOn, reportType, reportId, reportPublicId);
            this.reportData = reportData;
        }

        public ReadyReport(String reportType, String reportId, String reportPublicId, JsonObject reportData) {
            this(DKUDateUtils.isoFormatLocalNow(), reportType, reportId, reportPublicId, reportData);
        }

        public ReadyReport(String reportName, JsonObject reportData) {
            this(reportName, reportName, reportName, reportData);
        }

        public ReadyReport cloneWithoutPrivateInfo() {
            return new ReadyReport(this.builtOn, this.reportType, null, this.reportPublicId, this.reportData);
        }

        public ReadyReportInfo asInfo() {
            return new ReadyReportInfo(this.builtOn, this.reportType, this.reportId, this.reportPublicId);
        }
    }

    public static class ReadyReportInfo {
        public final String builtOn;
        public final String reportId;
        public final String reportPublicId;
        public final String reportType;

        protected ReadyReportInfo(String builtOn, String reportType, String reportId, String reportPublicId) {
            this.builtOn = builtOn;
            this.reportType = reportType;
            this.reportId = reportId;
            this.reportPublicId = reportPublicId;
        }
    }
}

