/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.util;

import com.dataiku.common.rpc.PEMUtils;
import com.dataiku.common.server.APIError;
import com.dataiku.dip.ProxySettings;
import com.dataiku.dip.futures.FutureAborter;
import com.dataiku.dip.futures.FutureProgress;
import com.dataiku.dip.futures.FutureProgressState;
import com.dataiku.dip.util.HTTPClientBaseUtils;
import com.dataiku.dip.util.ProxyUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.PerfUtils;
import com.dataiku.dss.shadelib.org.apache.commons.io.IOUtils;
import com.dataiku.dss.shadelib.org.apache.http.Header;
import com.dataiku.dss.shadelib.org.apache.http.HttpEntity;
import com.dataiku.dss.shadelib.org.apache.http.HttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.CloseableHttpResponse;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpGet;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpHead;
import com.dataiku.dss.shadelib.org.apache.http.client.methods.HttpUriRequest;
import com.dataiku.dss.shadelib.org.apache.http.config.Registry;
import com.dataiku.dss.shadelib.org.apache.http.config.RegistryBuilder;
import com.dataiku.dss.shadelib.org.apache.http.conn.socket.PlainConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.NoopHostnameVerifier;
import com.dataiku.dss.shadelib.org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import com.dataiku.dss.shadelib.org.apache.http.impl.client.DefaultHttpClient;
import com.dataiku.dss.shadelib.org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import com.dataiku.dss.shadelib.org.apache.http.ssl.SSLContexts;
import com.dataiku.dss.shadelib.org.apache.http.ssl.TrustStrategy;
import com.dataiku.dss.shadelib.org.apache.http.util.EntityUtils;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class HTTPClientUtils
extends HTTPClientBaseUtils {
    private static final int BUFFER_SIZE = 82944;
    private static Logger logger = Logger.getLogger((String)"dip.http.utils");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getFromJSON_GET(String url, Class<T> ofClass, Map<String, String> specialHeaders, @Nullable ProxySettings proxySettings) throws IOException, APIError.APIErrorException {
        HttpGet get = new HttpGet(url);
        if (specialHeaders != null) {
            for (Map.Entry<String, String> specialHeader : specialHeaders.entrySet()) {
                get.setHeader(specialHeader.getKey(), specialHeader.getValue());
            }
        }
        DefaultHttpClient client = new DefaultHttpClient();
        client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
        ProxyUtils.applyProxySettings(proxySettings, client);
        try {
            T t;
            CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
            try {
                t = HTTPClientUtils.handleJSONResp((HttpResponse)resp, ofClass, HTTPClientUtils::handleAPIError);
            }
            catch (Throwable throwable) {
                try {
                    EntityUtils.consume((HttpEntity)resp.getEntity());
                    throw throwable;
                }
                catch (Exception e) {
                    throw new IOException("Error while trying to GET url", e);
                }
            }
            EntityUtils.consume((HttpEntity)resp.getEntity());
            return t;
        }
        finally {
            client.getConnectionManager().shutdown();
        }
    }

    public static void downloadToFile(String url, File target, Map<String, String> specialHeaders, @Nullable ProxySettings proxySettings) throws IOException, APIError.APIErrorException {
        block32: {
            HttpHead head = new HttpHead(url);
            HttpGet get = new HttpGet(url);
            if (specialHeaders != null) {
                for (Map.Entry<String, String> specialHeader : specialHeaders.entrySet()) {
                    get.setHeader(specialHeader.getKey(), specialHeader.getValue());
                }
            }
            DefaultHttpClient client = new DefaultHttpClient();
            client.addRequestInterceptor(PerfUtils.MARK_HTTP_REQUEST_INTERCEPTOR);
            ProxyUtils.applyProxySettings(proxySettings, client);
            try {
                long expectedLength;
                try {
                    CloseableHttpResponse headResp = client.execute((HttpUriRequest)head);
                    expectedLength = headResp.containsHeader("Content-Length") ? Long.parseLong(headResp.getFirstHeader("Content-Length").getValue()) : -1L;
                }
                catch (Exception e) {
                    logger.info((Object)"HEAD request not supported, assuming unbounded content", (Throwable)e);
                    expectedLength = -1L;
                }
                CloseableHttpResponse resp = client.execute((HttpUriRequest)get);
                try {
                    int code = resp.getStatusLine().getStatusCode();
                    if (code == 200) {
                        InputStream stream = resp.getEntity().getContent();
                        try (ProgressOutputStream os = new ProgressOutputStream(new FileOutputStream(target), expectedLength);
                             FutureProgress.AutocloseableFutureProgressState state = FutureProgress.pushAutoCloseableState("Downloading", expectedLength > 0L ? 1.0 : 0.0, expectedLength > 0L ? FutureProgressState.StateUnit.NONE : FutureProgressState.StateUnit.SIZE);
                             FutureAborter.AutoCloseableAbortHook aborting = FutureAborter.pushAutoCloseableHook((Runnable)new DownloadAborter(os));){
                            IOUtils.copy((InputStream)stream, (OutputStream)os);
                            break block32;
                        }
                    }
                    String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (String)"utf8");
                    throw new IOException("Unknown error while GETting: " + s);
                }
                catch (Exception e) {
                    get.abort();
                    throw e;
                }
                finally {
                    EntityUtils.consume((HttpEntity)resp.getEntity());
                }
            }
            catch (Exception e) {
                throw new IOException("Error while trying to download URL", e);
            }
            finally {
                client.getConnectionManager().shutdown();
            }
        }
    }

    private HTTPClientUtils() {
    }

    public static PoolingHttpClientConnectionManager buildPoolingHttpClientConnectionManager(String serverCertPEM, boolean trustAllSSLCertificates) {
        if (StringUtils.isNotBlank((String)serverCertPEM)) {
            logger.info((Object)"Enabling manual trust of server cert");
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(PEMUtils.createTrustStoreFromPEM(serverCertPEM), null).build();
                Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
                return new PoolingHttpClientConnectionManager(registry);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to trust certificates", e);
            }
        }
        if (trustAllSSLCertificates) {
            logger.info((Object)"Enabling trust of all certificates");
            try {
                SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                    public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        return true;
                    }
                }).build();
                Registry registry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
                return new PoolingHttpClientConnectionManager(registry);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to trust certificates", e);
            }
        }
        return new PoolingHttpClientConnectionManager();
    }

    public static <T> T handleJSONResp(HttpResponse resp, Class<T> ofClazz, ApiErrorHandler handleAPIError) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            return null;
        }
        if (code == 200) {
            return (T)JSON.parse((InputStream)resp.getEntity().getContent(), ofClazz);
        }
        if (resp.getEntity().getContentType() != null && resp.getEntity().getContentType().getValue().startsWith("application/json")) {
            logger.warn((Object)("Got response code " + code));
            throw handleAPIError.apply(resp);
        }
        logger.warn((Object)("Got response code " + code));
        String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        throw new IOException("Unknown error on command (HTTP code:" + code + "):" + s);
    }

    public static IOException handleAPIError(HttpResponse resp) throws IOException {
        String content = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        APIError apiError = (APIError)JSON.parse((String)content, APIError.class);
        apiError.httpStatusCode = resp.getStatusLine().getStatusCode();
        if (resp.getAllHeaders() != null) {
            apiError.headers = new HashMap<String, String>();
            for (Header header : resp.getAllHeaders()) {
                apiError.headers.put(header.getName(), header.getValue());
            }
        }
        return new APIError.APIErrorException(apiError);
    }

    public static IOException handleAPIError(int statusCode, String content) {
        APIError apiError = (APIError)JSON.parse((String)content, APIError.class);
        apiError.httpStatusCode = statusCode;
        return new APIError.APIErrorException(apiError);
    }

    public static <T> T handleJSONResp(HttpResponse resp, TypeToken<T> ofClazz, ApiErrorHandler handleAPIError) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            return null;
        }
        if (code == 200) {
            return (T)JSON.parse((InputStream)resp.getEntity().getContent(), ofClazz);
        }
        if (resp.getEntity().getContentType().getValue().startsWith("application/json")) {
            logger.warn((Object)("Got response code " + code));
            throw handleAPIError.apply(resp);
        }
        String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        throw new IOException("Unknown error on command: " + s);
    }

    public static String encodeToBase64String(InputStream input) throws IOException {
        StringBuilder result = new StringBuilder();
        Base64.Encoder encoder = Base64.getEncoder();
        try (BufferedInputStream bis = new BufferedInputStream(input);){
            int bytesRead;
            byte[] buffer = new byte[82944];
            while ((bytesRead = IOUtils.read((InputStream)bis, (byte[])buffer)) > 0) {
                result.append(encoder.encodeToString(Arrays.copyOfRange(buffer, 0, bytesRead)));
            }
        }
        return result.toString();
    }

    public static String handleStringResp(HttpResponse resp) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            return null;
        }
        if (code == 200) {
            String contentType = null == resp.getEntity().getContentType() ? null : resp.getEntity().getContentType().getValue();
            if (null == contentType || org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/json") || org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"application/xml") || org.apache.commons.lang3.StringUtils.startsWithIgnoreCase((CharSequence)contentType, (CharSequence)"text/")) {
                return IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            }
            InputStream inputStream = resp.getEntity().getContent();
            return HTTPClientUtils.encodeToBase64String(inputStream);
        }
        if (resp.getEntity().getContentType().getValue().contains("application/json")) {
            String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            JsonObject jsonObject = (JsonObject)JSON.parse((String)s, JsonObject.class);
            if (jsonObject != null) {
                if (jsonObject.entrySet().size() == 2 && jsonObject.has("error") && jsonObject.has("message")) {
                    APIError apiErr = new APIError("API call failed", jsonObject.get("error").getAsString() + ": " + jsonObject.get("message").getAsString(), code);
                    throw new APIError.APIErrorException(apiErr);
                }
                throw HTTPClientUtils.handleAPIError(resp.getStatusLine().getStatusCode(), s);
            }
            throw new IOException("Call failed - could not get error details: " + s);
        }
        String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        throw new IOException("Unknown error on command: " + s);
    }

    public static InputStream handleInputStreamResp(HttpResponse resp) throws IOException {
        int code = resp.getStatusLine().getStatusCode();
        if (code == 204) {
            return null;
        }
        if (code == 200) {
            return resp.getEntity().getContent();
        }
        if (resp.getEntity().getContentType().getValue().contains("application/json")) {
            String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
            JsonObject jsonObject = (JsonObject)JSON.parse((String)s, JsonObject.class);
            if (jsonObject != null) {
                if (jsonObject.entrySet().size() == 2 && jsonObject.has("error") && jsonObject.has("message")) {
                    APIError apiErr = new APIError("API call failed", jsonObject.get("error").getAsString() + ": " + jsonObject.get("message").getAsString(), code);
                    throw new APIError.APIErrorException(apiErr);
                }
                throw HTTPClientUtils.handleAPIError(resp.getStatusLine().getStatusCode(), s);
            }
            throw new IOException("Call failed - could not get error details: " + s);
        }
        String s = IOUtils.toString((InputStream)resp.getEntity().getContent(), (Charset)StandardCharsets.UTF_8);
        throw new IOException("Unknown error on command: " + s);
    }

    public static interface ApiErrorHandler {
        public IOException apply(HttpResponse var1) throws IOException;
    }

    private static class ProgressOutputStream
    extends OutputStream {
        private OutputStream underlying;
        private long count;
        private long expectedLength;

        public ProgressOutputStream(OutputStream underlying, long expectedLength) {
            this.underlying = underlying;
            this.expectedLength = expectedLength;
            this.count = 0L;
        }

        private void incrementCount(int amount) throws IOException {
            this.count += (long)amount;
            try {
                if (this.expectedLength > 0L) {
                    FutureProgress.updateState(100.0 * (double)this.count / (double)this.expectedLength);
                } else {
                    FutureProgress.updateState(this.count);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.close();
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.underlying.close();
        }

        @Override
        public void flush() throws IOException {
            this.underlying.flush();
        }

        @Override
        public void write(int b) throws IOException {
            this.underlying.write(b);
            this.incrementCount(1);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.underlying.write(b);
            this.incrementCount(b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.underlying.write(b, off, len);
            this.incrementCount(len);
        }
    }

    private static class DownloadAborter
    implements Runnable {
        private OutputStream os;

        public DownloadAborter(OutputStream os) {
            this.os = os;
        }

        @Override
        public void run() {
            try {
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

