/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.utils;

import com.dataiku.dip.FeatureFlags;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dss.shadelib.org.apache.http.HttpRequest;
import com.dataiku.dss.shadelib.org.apache.http.HttpRequestInterceptor;
import com.dataiku.dss.shadelib.org.apache.http.protocol.HttpContext;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.log4j.Logger;

public final class PerfUtils {
    private static final List<Runnable> handlers = new CopyOnWriteArrayList<Runnable>();
    private static final ThreadLocal<Boolean> inHandler = ThreadLocal.withInitial(() -> false);
    public static final HttpRequestInterceptor MARK_HTTP_REQUEST_INTERCEPTOR = new HttpRequestInterceptor(){

        public void process(HttpRequest httpRequest, HttpContext httpContext) {
            PerfUtils.markSlowCode();
        }
    };
    private static final Logger logger = Logger.getLogger((String)"dku.perfutils");

    private PerfUtils() {
    }

    public static void registerSlowCodeHandler(ExceptionUtils.ThrowingRunnable<?> handler) {
        if (FeatureFlags.isEnabled("slowCodeHandler")) {
            Runnable handlerInstance = () -> {
                if (Boolean.FALSE.equals(inHandler.get())) {
                    try {
                        inHandler.set(true);
                        handler.run();
                    }
                    catch (Exception e) {
                        logger.error((Object)"Error in slow code handler", (Throwable)e);
                    }
                    finally {
                        inHandler.remove();
                    }
                }
            };
            handlers.add(handlerInstance);
        }
    }

    public static void markSlowCode() {
        handlers.forEach(Runnable::run);
    }
}

