/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import twitter4j.GeoLocation;
import twitter4j.HttpParameter;

public final class StatusUpdate
implements Serializable {
    private static final long serialVersionUID = 7422094739799350035L;
    private final String status;
    private long inReplyToStatusId = -1L;
    private GeoLocation location = null;
    private String placeId = null;
    private boolean displayCoordinates = true;
    private boolean possiblySensitive;
    private String mediaName;
    private transient InputStream mediaBody;
    private File mediaFile;

    public StatusUpdate(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public long getInReplyToStatusId() {
        return this.inReplyToStatusId;
    }

    public void setInReplyToStatusId(long inReplyToStatusId) {
        this.inReplyToStatusId = inReplyToStatusId;
    }

    public StatusUpdate inReplyToStatusId(long inReplyToStatusId) {
        this.setInReplyToStatusId(inReplyToStatusId);
        return this;
    }

    public GeoLocation getLocation() {
        return this.location;
    }

    public void setLocation(GeoLocation location) {
        this.location = location;
    }

    public StatusUpdate location(GeoLocation location) {
        this.setLocation(location);
        return this;
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public void setPlaceId(String placeId) {
        this.placeId = placeId;
    }

    public StatusUpdate placeId(String placeId) {
        this.setPlaceId(placeId);
        return this;
    }

    public boolean isDisplayCoordinates() {
        return this.displayCoordinates;
    }

    public void setDisplayCoordinates(boolean displayCoordinates) {
        this.displayCoordinates = displayCoordinates;
    }

    public StatusUpdate displayCoordinates(boolean displayCoordinates) {
        this.setDisplayCoordinates(displayCoordinates);
        return this;
    }

    public void setMedia(File file) {
        this.mediaFile = file;
    }

    public StatusUpdate media(File file) {
        this.setMedia(file);
        return this;
    }

    public void setMedia(String name, InputStream body) {
        this.mediaName = name;
        this.mediaBody = body;
    }

    boolean isWithMedia() {
        return this.mediaFile != null || this.mediaName != null;
    }

    public StatusUpdate media(String name, InputStream body) {
        this.setMedia(name, body);
        return this;
    }

    public void setPossiblySensitive(boolean possiblySensitive) {
        this.possiblySensitive = possiblySensitive;
    }

    public StatusUpdate possiblySensitive(boolean possiblySensitive) {
        this.setPossiblySensitive(possiblySensitive);
        return this;
    }

    public boolean isPossiblySensitive() {
        return this.possiblySensitive;
    }

    HttpParameter[] asHttpParameterArray() {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>();
        this.appendParameter("status", this.status, params);
        if (-1L != this.inReplyToStatusId) {
            this.appendParameter("in_reply_to_status_id", this.inReplyToStatusId, (List<HttpParameter>)params);
        }
        if (this.location != null) {
            this.appendParameter("lat", this.location.getLatitude(), params);
            this.appendParameter("long", this.location.getLongitude(), params);
        }
        this.appendParameter("place_id", this.placeId, params);
        if (!this.displayCoordinates) {
            this.appendParameter("display_coordinates", "false", params);
        }
        if (null != this.mediaFile) {
            params.add(new HttpParameter("media[]", this.mediaFile));
            params.add(new HttpParameter("possibly_sensitive", this.possiblySensitive));
        } else if (this.mediaName != null && this.mediaBody != null) {
            params.add(new HttpParameter("media[]", this.mediaName, this.mediaBody));
            params.add(new HttpParameter("possibly_sensitive", this.possiblySensitive));
        }
        HttpParameter[] paramArray = new HttpParameter[params.size()];
        return params.toArray(paramArray);
    }

    private void appendParameter(String name, String value, List<HttpParameter> params) {
        if (value != null) {
            params.add(new HttpParameter(name, value));
        }
    }

    private void appendParameter(String name, double value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    private void appendParameter(String name, long value, List<HttpParameter> params) {
        params.add(new HttpParameter(name, String.valueOf(value)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusUpdate that = (StatusUpdate)o;
        if (this.displayCoordinates != that.displayCoordinates) {
            return false;
        }
        if (this.inReplyToStatusId != that.inReplyToStatusId) {
            return false;
        }
        if (this.possiblySensitive != that.possiblySensitive) {
            return false;
        }
        if (this.location != null ? !this.location.equals(that.location) : that.location != null) {
            return false;
        }
        if (this.mediaBody != null ? !this.mediaBody.equals(that.mediaBody) : that.mediaBody != null) {
            return false;
        }
        if (this.mediaFile != null ? !this.mediaFile.equals(that.mediaFile) : that.mediaFile != null) {
            return false;
        }
        if (this.mediaName != null ? !this.mediaName.equals(that.mediaName) : that.mediaName != null) {
            return false;
        }
        if (this.placeId != null ? !this.placeId.equals(that.placeId) : that.placeId != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        int result = this.status != null ? this.status.hashCode() : 0;
        result = 31 * result + (int)(this.inReplyToStatusId ^ this.inReplyToStatusId >>> 32);
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (this.placeId != null ? this.placeId.hashCode() : 0);
        result = 31 * result + (this.displayCoordinates ? 1 : 0);
        result = 31 * result + (this.possiblySensitive ? 1 : 0);
        result = 31 * result + (this.mediaName != null ? this.mediaName.hashCode() : 0);
        result = 31 * result + (this.mediaBody != null ? this.mediaBody.hashCode() : 0);
        result = 31 * result + (this.mediaFile != null ? this.mediaFile.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "StatusUpdate{status='" + this.status + '\'' + ", inReplyToStatusId=" + this.inReplyToStatusId + ", location=" + this.location + ", placeId='" + this.placeId + '\'' + ", displayCoordinates=" + this.displayCoordinates + ", possiblySensitive=" + this.possiblySensitive + ", mediaName='" + this.mediaName + '\'' + ", mediaBody=" + this.mediaBody + ", mediaFile=" + this.mediaFile + '}';
    }
}

