/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security.impl;

import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.crypto.SecretKey;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.component.AbstractInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import net.shibboleth.utilities.java.support.primitive.TimerSupport;
import net.shibboleth.utilities.java.support.resource.Resource;
import net.shibboleth.utilities.java.support.security.DataSealerKeyStrategy;
import net.shibboleth.utilities.java.support.security.KeyNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicKeystoreKeyStrategy
extends AbstractInitializableComponent
implements DataSealerKeyStrategy {
    @Nonnull
    @NotEmpty
    public static final String CURRENT_VERSION_PROP = "CurrentVersion";
    @Nonnull
    private Logger log = LoggerFactory.getLogger(BasicKeystoreKeyStrategy.class);
    @NonnullAfterInit
    private String keystoreType = "JCEKS";
    @NonnullAfterInit
    private Resource keystoreResource;
    @NonnullAfterInit
    private Resource keyVersionResource;
    @NonnullAfterInit
    private String keystorePassword;
    @NonnullAfterInit
    private String keyAlias;
    @NonnullAfterInit
    private String keyPassword;
    @NonnullAfterInit
    private String currentAlias;
    @NonnullAfterInit
    private SecretKey defaultKey;
    @Nonnull
    private Duration updateInterval = Duration.ofMinutes(15L);
    private Timer updateTaskTimer;
    private Timer internalTaskTimer;
    private TimerTask updateTask;

    public void setKeystoreType(@Nonnull @NotEmpty String type) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.keystoreType = Constraint.isNotNull(StringSupport.trimOrNull(type), "Keystore type cannot be null or empty");
    }

    public void setKeystoreResource(@Nonnull @NotEmpty Resource resource) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.keystoreResource = Constraint.isNotNull(resource, "Keystore resource cannot be null");
    }

    public void setKeyVersionResource(@Nonnull @NotEmpty Resource resource) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.keyVersionResource = Constraint.isNotNull(resource, "Key version resource cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeystorePassword(@Nullable String password) {
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (password != null && !password.isEmpty()) {
                this.keystorePassword = password;
                if (this.isInitialized() && this.keyPassword != null) {
                    try {
                        this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {}
                }
            } else {
                this.keystorePassword = null;
            }
        }
    }

    public void setKeyAlias(@Nonnull @NotEmpty String alias) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.keyAlias = Constraint.isNotNull(StringSupport.trimOrNull(alias), "Key alias base cannot be null or empty");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyPassword(@Nullable String password) {
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (password != null && !password.isEmpty()) {
                this.keyPassword = password;
                if (this.isInitialized() && this.keystorePassword != null) {
                    try {
                        this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {}
                }
            } else {
                this.keyPassword = null;
            }
        }
    }

    public void setUpdateInterval(@Nonnull Duration interval) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        Constraint.isNotNull(interval, "Interval cannot be null");
        Constraint.isFalse(interval.isNegative(), "Interval cannot be negative");
        this.updateInterval = interval;
    }

    public void setUpdateTaskTimer(@Nullable Timer timer) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        this.updateTaskTimer = timer;
    }

    @Override
    public void doInitialize() throws ComponentInitializationException {
        try {
            try {
                Constraint.isNotNull(this.keystoreType, "Keystore type cannot be null");
                Constraint.isNotNull(this.keystoreResource, "Keystore resource cannot be null");
                Constraint.isNotNull(this.keyVersionResource, "Key version resource cannot be null");
                Constraint.isNotNull(this.keyAlias, "Key alias base cannot be null");
            }
            catch (ConstraintViolationException e) {
                throw new ComponentInitializationException(e);
            }
            this.updateDefaultKey();
        }
        catch (KeyException e) {
            this.log.error("Error loading default key from base name '{}' {}", (Object)this.keyAlias, (Object)e.getMessage());
            throw new ComponentInitializationException("Exception loading the default key", e);
        }
        if (!this.updateInterval.isZero()) {
            this.updateTask = new TimerTask(){

                @Override
                public void run() {
                    try {
                        BasicKeystoreKeyStrategy.this.updateDefaultKey();
                    }
                    catch (KeyException keyException) {
                        // empty catch block
                    }
                }
            };
            this.internalTaskTimer = this.updateTaskTimer == null ? new Timer(TimerSupport.getTimerName(this), true) : this.updateTaskTimer;
            this.internalTaskTimer.schedule(this.updateTask, this.updateInterval.toMillis(), this.updateInterval.toMillis());
        }
    }

    @Override
    protected void doDestroy() {
        if (this.updateTask != null) {
            this.updateTask.cancel();
            this.updateTask = null;
            if (this.updateTaskTimer == null) {
                this.internalTaskTimer.cancel();
            }
            this.internalTaskTimer = null;
        }
        super.doDestroy();
    }

    @Override
    @Nonnull
    public Pair<String, SecretKey> getDefaultKey() throws KeyException {
        ComponentSupport.ifNotInitializedThrowUninitializedComponentException(this);
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (this.defaultKey != null) {
                return new Pair<String, SecretKey>(this.currentAlias, this.defaultKey);
            }
            throw new KeyException("Passwords not supplied, keystore is locked");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public SecretKey getKey(@Nonnull @NotEmpty String name) throws KeyException {
        SecretKey secretKey;
        block15: {
            BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
            synchronized (basicKeystoreKeyStrategy) {
                if (this.defaultKey != null && name.equals(this.currentAlias)) {
                    return this.defaultKey;
                }
                if (this.keystorePassword == null || this.keyPassword == null) {
                    throw new KeyException("Passwords not supplied, keystore is locked");
                }
            }
            KeyStore ks = KeyStore.getInstance(this.keystoreType);
            InputStream ksResourceStream = this.keystoreResource.getInputStream();
            try {
                ks.load(ksResourceStream, this.keystorePassword.toCharArray());
                Key loadedKey = ks.getKey(name, this.keyPassword.toCharArray());
                if (loadedKey == null) {
                    this.log.info("Key '{}' not found", (Object)name);
                    throw new KeyNotFoundException("Key was not present in keystore");
                }
                if (!(loadedKey instanceof SecretKey)) {
                    this.log.error("Key '{}' is not a symmetric key", (Object)name);
                    throw new KeyException("Key was of incorrect type");
                }
                secretKey = (SecretKey)loadedKey;
                if (ksResourceStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (ksResourceStream != null) {
                        try {
                            ksResourceStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
                    this.log.error("Error loading key named '{}': {}", (Object)name, (Object)e.getMessage());
                    throw new KeyException(e);
                }
            }
            ksResourceStream.close();
        }
        return secretKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDefaultKey() throws KeyException {
        BasicKeystoreKeyStrategy basicKeystoreKeyStrategy = this;
        synchronized (basicKeystoreKeyStrategy) {
            if (this.keystorePassword == null || this.keyPassword == null) {
                this.log.info("Passwords not supplied, keystore left locked");
                return;
            }
            if (this.defaultKey == null) {
                try {
                    long lastModified = this.keyVersionResource.lastModified();
                    if (lastModified < Instant.now().minus(30L, ChronoUnit.DAYS).toEpochMilli()) {
                        this.log.warn("Keystore version resource unmodified in 30 days, consider rotating key");
                    }
                }
                catch (IOException e) {
                    this.log.debug("Unable to obtain keystore version resource modification time");
                }
            }
            try (InputStream is = this.keyVersionResource.getInputStream();){
                Properties props = new Properties();
                props.load(is);
                StringBuilder builder = new StringBuilder(this.keyAlias);
                builder.append(props.getProperty(CURRENT_VERSION_PROP, ""));
                String newAlias = builder.toString();
                if (this.currentAlias == null) {
                    this.log.info("Loading initial default key: {}", (Object)newAlias);
                } else if (!this.currentAlias.equals(newAlias)) {
                    this.log.info("Updating default key from {} to {}", (Object)this.currentAlias, (Object)newAlias);
                } else {
                    this.log.debug("Default key version has not changed, still {}", (Object)this.currentAlias);
                    return;
                }
                this.defaultKey = this.getKey(newAlias);
                this.currentAlias = newAlias;
                this.log.info("Default key updated to {}", (Object)this.currentAlias);
            }
            catch (IOException e) {
                this.log.error("IOException updating key version: {}", (Object)e.getMessage());
                throw new KeyException(e);
            }
        }
    }
}

