/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.lang;

import io.delta.kernel.internal.util.Tuple2;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class ListUtils {
    private ListUtils() {
    }

    public static <T> Tuple2<List<T>, List<T>> partition(List<T> list, Predicate<? super T> predicate) {
        Map<Boolean, List<T>> map = list.stream().collect(Collectors.partitioningBy(predicate));
        return new Tuple2<List<T>, List<T>>(map.get(true), map.get(false));
    }

    public static <T> T last(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T getFirst(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        return list.get(0);
    }

    public static <T> T getLast(List<T> list) {
        if (list.isEmpty()) {
            throw new NoSuchElementException();
        }
        return list.get(list.size() - 1);
    }
}

