/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.SQLNotebooksService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.sqlnotebooks.SQLNotebook;
import com.dataiku.dip.sqlnotebooks.SQLNotebookQuery;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/sql-notebooks"})
public class PublicAPISQLNotebooksController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private SQLNotebooksService sqlNotebooksService;

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listSQLNotebooks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws DKUSecurityException, IOException {
        List notebooks;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebooks = this.sqlNotebooksService.list(projectKey);
        }
        List result = notebooks.stream().map(SQLNotebook.SQLNotebookListItem::new).collect(Collectors.toList());
        PublicAPISQLNotebooksController.writeJSON((HttpServletResponse)resp, result);
        this.auditTrailService.generic("sql-notebooks-list").with("projectKey", projectKey).emit();
    }

    @AuditInline
    @RequestMapping(value={"/{notebookId}"}, method={RequestMethod.GET})
    public void getSQLNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookId) throws DKUSecurityException, IOException {
        SQLNotebook notebook;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebook = this.sqlNotebooksService.getMandatoryUnsafe(projectKey, notebookId);
        }
        PublicAPISQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)notebook);
        this.auditTrailService.generic("sql-notebook-read").with("projectKey", projectKey).with("notebookId", notebookId).emit();
    }

    @AuditInline
    @RequestMapping(value={"/{notebookId}"}, method={RequestMethod.PUT})
    public void updateSQLNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookId, @RequestBody SQLNotebook newNotebook) throws Exception {
        PublicAPISQLNotebooksController.checkProjectKey(projectKey, newNotebook);
        if (!notebookId.equals(newNotebook.id)) {
            throw new DKUControllerBase.MalformedRequestException("Field 'id' does not match the notebook id in the URL path");
        }
        try (RWTransaction transaction = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.connectionsService.checkUserForConnection(authCtx, newNotebook.connection);
            newNotebook = this.sqlNotebooksService.save(newNotebook, false);
            transaction.commit(String.format("Updated SQL notebook '%s'", notebookId));
        }
        PublicAPISQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newNotebook);
        this.auditTrailService.generic("sql-notebook-save").with("projectKey", newNotebook.projectKey).with("notebookId", newNotebook.id).with("connection", newNotebook.connection).emit();
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void createSQLNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestBody SQLNotebook newNotebook) throws Exception {
        PublicAPISQLNotebooksController.checkProjectKey(projectKey, newNotebook);
        if (newNotebook.id != null) {
            throw new DKUControllerBase.MalformedRequestException("Field 'id' is specified, it must not be specified");
        }
        try (RWTransaction transaction = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            newNotebook.id = this.sqlNotebooksService.create(authCtx, projectKey, newNotebook.connection, newNotebook.name, newNotebook.analyzedDataset);
            newNotebook = this.sqlNotebooksService.save(newNotebook, false);
            transaction.commit(String.format("Created SQL notebook '%s'", newNotebook.id));
        }
        PublicAPISQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)newNotebook);
        this.auditTrailService.generic("sql-notebook-create").with("projectKey", newNotebook.projectKey).with("notebookId", newNotebook.id).with("connection", newNotebook.connection).emit();
    }

    @AuditInline
    @RequestMapping(value={"/{notebookId}"}, method={RequestMethod.DELETE})
    public void deleteSQLNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookId) throws Exception {
        String commitMessage = String.format("Deleted SQL notebook '%s'", notebookId);
        try (RWTransaction transaction = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            this.sqlNotebooksService.delete(authCtx, projectKey, notebookId);
            transaction.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
        this.auditTrailService.generic("sql-notebook-delete").with("projectKey", projectKey).with("notebookId", notebookId).emit();
    }

    @AuditInline
    @RequestMapping(value={"/{notebookId}/history"}, method={RequestMethod.GET})
    public void getSQLNotebookHistory(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookId) throws DKUSecurityException, IOException {
        Map notebookQueries;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            boolean keepFutureIdInResponse = false;
            if (this.permissionsService.hasProjectPrivilege(authCtx, projectKey, Privileges.ProjectLevelPrivilegeType.WRITE_CONF)) {
                keepFutureIdInResponse = true;
            } else {
                this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            }
            notebookQueries = this.sqlNotebooksService.getHistory(projectKey, notebookId, keepFutureIdInResponse);
        }
        PublicAPISQLNotebooksController.writeJSON((HttpServletResponse)resp, (Object)notebookQueries);
        this.auditTrailService.generic("sql-notebook-read-history").with("projectKey", projectKey).with("notebookId", notebookId).emit();
    }

    @AuditInline
    @RequestMapping(value={"/{notebookId}/history"}, method={RequestMethod.PUT})
    public void setSQLNotebookHistory(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String notebookId, @RequestBody Map<String, List<SQLNotebookQuery>> history) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.sqlNotebooksService.setHistory_NT(authCtx, projectKey, notebookId, history);
        this.auditTrailService.generic("sql-notebook-save-history").with("projectKey", projectKey).with("notebookId", notebookId).emit();
    }

    @AuditInline
    @RequestMapping(value={"/{notebookId}/history/clear"}, method={RequestMethod.POST})
    public void clearSQLNotebookHistory(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String notebookId, @RequestBody ClearSQLNotebookHistoryRequest clearSQLNotebookHistoryRequest) throws Exception {
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.sqlNotebooksService.clearHistory_NT(authCtx, projectKey, notebookId, clearSQLNotebookHistoryRequest.cellId, clearSQLNotebookHistoryRequest.numRunsToRetain);
        this.auditTrailService.generic("sql-notebook-clear-history").with("projectKey", projectKey).with("notebookId", notebookId).with("cellId", clearSQLNotebookHistoryRequest.cellId).with("numRunsToRetain", (Number)clearSQLNotebookHistoryRequest.numRunsToRetain).emit();
    }

    private static void checkProjectKey(String projectKey, SQLNotebook sqlNotebook) {
        if (!projectKey.equals(sqlNotebook.projectKey)) {
            throw new DKUControllerBase.MalformedRequestException("Field 'projectKey' does not match the project key in the URL path");
        }
    }

    public static class ClearSQLNotebookHistoryRequest {
        public String cellId;
        public int numRunsToRetain;
    }
}

