/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.unifiedmonitoring;

import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.unifiedmonitoring.UnifiedMonitoringDeployerService;
import com.dataiku.dip.unifiedmonitoring.apiendpoint.AbstractMonitoredApiEndpoint;
import com.dataiku.dip.unifiedmonitoring.payloads.EndpointIdentifier;
import com.dataiku.dip.unifiedmonitoring.project.AbstractMonitoredProjectDeployment;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIUnifiedMonitoringDeployerController
extends PublicAPIControllerBase {
    @Autowired
    TransactionService transactionService;
    @Autowired
    MetaAuthService authService;
    @Autowired
    UnifiedMonitoringDeployerService unifiedMonitoringDeployerService;

    @AuditedCall(value={"msgType", "unified-monitoring-projects-list"})
    @RequestMapping(value={"/publicapi/unified-monitoring/deployer/projects"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AbstractMonitoredProjectDeployment> listMonitoredProjectDeployments(HttpServletRequest req) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
        }
        return this.unifiedMonitoringDeployerService.listMonitoredProjectDeployments(user);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoints-list"})
    @RequestMapping(value={"/publicapi/unified-monitoring/deployer/api-endpoints"}, method={RequestMethod.GET})
    @ResponseBody
    public List<AbstractMonitoredApiEndpoint> listMonitoredApiEndpoints(HttpServletRequest req, @RequestParam(required=false, defaultValue="true") boolean removeDuplicatedExternalEndpoints) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
        }
        return this.unifiedMonitoringDeployerService.listMonitoredApiEndpoints(user, removeDuplicatedExternalEndpoints);
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoints-with-activity-metrics-list"})
    @RequestMapping(value={"/publicapi/unified-monitoring/deployer/api-endpoints-with-activity-metrics"}, method={RequestMethod.POST})
    public void listMonitoredApiEndpointsWithActivityMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestBody(required=false) List<EndpointIdentifier> endpointsToFilterOn, @RequestParam(required=false, defaultValue="true") boolean removeDuplicatedExternalEndpoints) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
        }
        PublicAPIUnifiedMonitoringDeployerController.writeJSONWithNoNaNAndNull((HttpServletResponse)resp, (Object)this.unifiedMonitoringDeployerService.listMonitoredApiEndpointWithActivityMetrics(user, endpointsToFilterOn, removeDuplicatedExternalEndpoints));
    }

    @AuditedCall(value={"msgType", "unified-monitoring-api-endpoint-activity-metrics-get"})
    @RequestMapping(value={"/publicapi/unified-monitoring/deployer/activity-metrics"}, method={RequestMethod.POST})
    public void getActivityMetrics(HttpServletRequest req, HttpServletResponse resp, @RequestBody EndpointIdentifier endpointIdentifier) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
        }
        PublicAPIUnifiedMonitoringDeployerController.writeJSONWithNoNaNAndNull((HttpServletResponse)resp, (Object)this.unifiedMonitoringDeployerService.getActivityMetrics_Check(user, endpointIdentifier));
    }

    @AuditedCall(value={"msgType", "unified-monitoring-prometheus-metrics"})
    @RequestMapping(value={"/publicapi/unified-monitoring/deployer/metrics-prometheus"}, method={RequestMethod.GET})
    @ResponseBody
    public String getPrometheusMetrics(HttpServletRequest req, @RequestParam(defaultValue="") String name) throws Exception {
        AuthCtx user;
        try (Transaction t = this.transactionService.beginRead();){
            user = this.authService.getTicketOrKey(req);
        }
        return this.unifiedMonitoringDeployerService.getPrometheusMetrics(user, name);
    }
}

