/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import io.delta.storage.CloseableIterator;
import io.delta.storage.LineCloseableIterator;
import io.delta.storage.LogStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public abstract class HadoopFileSystemLogStore
extends LogStore {
    public HadoopFileSystemLogStore(Configuration configuration) {
        super(configuration);
    }

    @Override
    public CloseableIterator<String> read(Path path, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        FSDataInputStream fSDataInputStream = fileSystem.open(path);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fSDataInputStream, StandardCharsets.UTF_8));
        return new LineCloseableIterator(bufferedReader);
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        if (!fileSystem.exists(path.getParent())) {
            throw new FileNotFoundException(String.format("No such file or directory: %s", path.getParent()));
        }
        FileStatus[] fileStatusArray = fileSystem.listStatus(path.getParent());
        return Arrays.stream(fileStatusArray).filter(fileStatus -> fileStatus.getPath().getName().compareTo(path.getName()) >= 0).sorted(Comparator.comparing(fileStatus -> fileStatus.getPath().getName())).iterator();
    }

    @Override
    public Path resolvePathOnPhysicalStorage(Path path, Configuration configuration) throws IOException {
        return path.getFileSystem(configuration).makeQualified(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeWithRename(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        block17: {
            FileSystem fileSystem = path.getFileSystem(configuration);
            if (!fileSystem.exists(path.getParent())) {
                throw new FileNotFoundException(String.format("No such file or directory: %s", path.getParent()));
            }
            if (bl.booleanValue()) {
                try (FSDataOutputStream fSDataOutputStream = fileSystem.create(path, true);){
                    while (iterator.hasNext()) {
                        fSDataOutputStream.write((iterator.next() + "\n").getBytes(StandardCharsets.UTF_8));
                    }
                }
            }
            if (fileSystem.exists(path)) {
                throw new java.nio.file.FileAlreadyExistsException(path.toString());
            }
            Path path2 = this.createTempPath(path);
            boolean bl2 = false;
            boolean bl3 = false;
            FSDataOutputStream fSDataOutputStream = fileSystem.create(path2);
            try {
                while (iterator.hasNext()) {
                    fSDataOutputStream.write((iterator.next() + "\n").getBytes(StandardCharsets.UTF_8));
                }
                fSDataOutputStream.close();
                bl2 = true;
                try {
                    if (fileSystem.rename(path2, path)) {
                        bl3 = true;
                        break block17;
                    }
                    if (fileSystem.exists(path)) {
                        throw new java.nio.file.FileAlreadyExistsException(path.toString());
                    }
                    throw new IllegalStateException(String.format("Cannot rename %s to %s", path2, path));
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw new java.nio.file.FileAlreadyExistsException(path.toString());
                }
            }
            finally {
                if (!bl2) {
                    fSDataOutputStream.close();
                }
                if (!bl3) {
                    fileSystem.delete(path2, false);
                }
            }
        }
    }

    protected Path createTempPath(Path path) {
        return new Path(path.getParent(), String.format(".%s.%s.tmp", path.getName(), UUID.randomUUID()));
    }
}

