/*
 * Decompiled with CFR 0.152.
 */
package io.delta.storage;

import com.google.common.io.CountingOutputStream;
import io.delta.storage.HadoopFileSystemLogStore;
import io.delta.storage.internal.PathLock;
import io.delta.storage.internal.S3LogStoreUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;

public class S3SingleDriverLogStore
extends HadoopFileSystemLogStore {
    private final boolean enableFastListFrom = this.initHadoopConf().getBoolean("delta.enableFastS3AListFrom", false);
    private static final PathLock pathLock = new PathLock();

    public S3SingleDriverLogStore(Configuration configuration) {
        super(configuration);
    }

    private Path resolvePath(FileSystem fileSystem, Path path) {
        return this.stripUserInfo(fileSystem.makeQualified(path));
    }

    private Path stripUserInfo(Path path) {
        URI uRI = path.toUri();
        try {
            URI uRI2 = new URI(uRI.getScheme(), null, uRI.getHost(), uRI.getPort(), uRI.getPath(), uRI.getQuery(), uRI.getFragment());
            return new Path(uRI2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
    }

    private Iterator<FileStatus> listFromInternal(FileSystem fileSystem, Path path) throws IOException {
        Path path2 = path.getParent();
        if (!fileSystem.exists(path2)) {
            throw new FileNotFoundException(String.format("No such file or directory: %s", path2));
        }
        FileStatus[] fileStatusArray = fileSystem instanceof LocalFileSystem || fileSystem instanceof RawLocalFileSystem || !this.enableFastListFrom ? fileSystem.listStatus(path2) : S3LogStoreUtil.s3ListFromArray(fileSystem, path, path2);
        return Arrays.stream(fileStatusArray).filter(fileStatus -> fileStatus.getPath().getName().compareTo(path.getName()) >= 0).sorted(Comparator.comparing(fileStatus -> fileStatus.getPath().getName())).iterator();
    }

    @Override
    public void write(Path path, Iterator<String> iterator, Boolean bl, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        Path path2 = this.resolvePath(fileSystem, path);
        try {
            pathLock.acquire(path2);
            try {
                if (fileSystem.exists(path2) && !bl.booleanValue()) {
                    throw new java.nio.file.FileAlreadyExistsException(path2.toUri().toString());
                }
                CountingOutputStream countingOutputStream = new CountingOutputStream((OutputStream)fileSystem.create(path2, bl.booleanValue()));
                while (iterator.hasNext()) {
                    countingOutputStream.write((iterator.next() + "\n").getBytes(StandardCharsets.UTF_8));
                }
                countingOutputStream.close();
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(fileAlreadyExistsException.getMessage());
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptedIOException(interruptedException.getMessage());
        }
        finally {
            pathLock.release(path2);
        }
    }

    @Override
    public Iterator<FileStatus> listFrom(Path path, Configuration configuration) throws IOException {
        FileSystem fileSystem = path.getFileSystem(configuration);
        Path path2 = this.resolvePath(fileSystem, path);
        return this.listFromInternal(fileSystem, path2);
    }

    @Override
    public Boolean isPartialWriteVisible(Path path, Configuration configuration) {
        return false;
    }
}

