/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.datasets;

import com.dataiku.dip.utils.JSON;
import com.dataiku.j2ts.annotations.UIModel;
import javax.annotation.Nullable;

@UIModel
public class SamplingParam {
    public SamplingMethod samplingMethod = SamplingMethod.FULL;
    public long maxRecords = -1L;
    public double targetRatio = 0.02;
    @Nullable
    public String column = null;
    public boolean ascending = true;
    public long withinFirstN = -1L;
    public long maxReadUncompressedBytes = -1L;
    @Nullable
    public Long seed;

    public String toString() {
        return JSON.pretty((Object)this);
    }

    public static SamplingParam newHEADOnly() {
        SamplingParam sp = new SamplingParam();
        sp.samplingMethod = SamplingMethod.HEAD_SEQUENTIAL;
        sp.maxRecords = 50000L;
        return sp;
    }

    public static SamplingParam newFull() {
        SamplingParam sp = new SamplingParam();
        sp.samplingMethod = SamplingMethod.FULL;
        return sp;
    }

    public static enum SamplingMethod {
        FULL,
        HEAD_SEQUENTIAL,
        TAIL_SEQUENTIAL,
        RANDOM_FIXED_NB,
        RANDOM_FIXED_RATIO,
        COLUMN_BASED(true),
        STRATIFIED_TARGET_NB_EXACT(true),
        STRATIFIED_TARGET_RATIO_EXACT(true),
        CLASS_REBALANCE_TARGET_NB_APPROX(true),
        CLASS_REBALANCE_TARGET_RATIO_APPROX(true),
        RANDOM_FIXED_NB_EXACT,
        RANDOM_FIXED_RATIO_EXACT,
        COLUMN_ORDERED(true);

        public final boolean needsColumn;

        private SamplingMethod(boolean needsColumn) {
            this.needsColumn = needsColumn;
        }

        private SamplingMethod() {
            this.needsColumn = false;
        }
    }
}

