/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.fs;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.fs.FSBrowsePath;
import com.dataiku.dip.fs.FSEnumerationResult;
import com.dataiku.dip.fs.FSEnumerationSettings;
import com.dataiku.dip.fs.FSPathOrDirectory;
import com.dataiku.dip.input.stream.EnrichedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public interface FSProvider
extends AutoCloseable {
    @Override
    public void close() throws IOException;

    public FSBrowsePath browse(String var1, FSBrowseStrategy var2) throws IOException, DKUSecurityException, CodedException;

    public FSEnumerationResult enumerateRecursive(String var1, FSEnumerationSettings var2) throws IOException, CodedException, DKUSecurityException;

    public FSPathOrDirectory stat(String var1) throws IOException, CodedException, DKUSecurityException;

    public EnrichedInputStream read(String var1) throws IOException, CodedException, DKUSecurityException;

    public OutputStream write(String var1) throws IOException, CodedException, DKUSecurityException;

    public void setLastModified(String var1, long var2) throws IOException, CodedException, DKUSecurityException;

    public void deleteRecursive(String var1) throws IOException, CodedException, DKUSecurityException;

    public boolean deleteFile(String var1) throws IOException, CodedException, DKUSecurityException;

    public boolean deleteDirectory(String var1) throws IOException, CodedException, DKUSecurityException;

    public void moveDirectory(String var1, String var2) throws IOException, CodedException, DKUSecurityException;

    public void moveFile(String var1, String var2) throws IOException, CodedException, DKUSecurityException;

    public Map<String, String> getAccessInfo(boolean var1) throws IOException, CodedException, DKUSecurityException;

    public static enum FSBrowseStrategy {
        FILE_OR_DIRECTORY,
        FILE,
        DIRECTORY;

    }
}

