/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.index;

import com.dataiku.dss.shadelib.org.apache.lucene.index.CodecReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.FilterCodecReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.MergePolicy;
import com.dataiku.dss.shadelib.org.apache.lucene.index.OneMergeWrappingMergePolicy;
import com.dataiku.dss.shadelib.org.apache.lucene.index.SegmentCommitInfo;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanClause;
import com.dataiku.dss.shadelib.org.apache.lucene.search.BooleanQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.DocIdSetIterator;
import com.dataiku.dss.shadelib.org.apache.lucene.search.FieldExistsQuery;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ScoreMode;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Scorer;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Weight;
import com.dataiku.dss.shadelib.org.apache.lucene.util.Bits;
import com.dataiku.dss.shadelib.org.apache.lucene.util.FixedBitSet;
import com.dataiku.dss.shadelib.org.apache.lucene.util.IOSupplier;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;

public final class SoftDeletesRetentionMergePolicy
extends OneMergeWrappingMergePolicy {
    private final String field;
    private final Supplier<Query> retentionQuerySupplier;

    public SoftDeletesRetentionMergePolicy(String field, Supplier<Query> retentionQuerySupplier, MergePolicy in) {
        super(in, toWrap -> new MergePolicy.OneMerge(toWrap.segments, (MergePolicy.OneMerge)toWrap, field, retentionQuerySupplier){
            final /* synthetic */ MergePolicy.OneMerge val$toWrap;
            final /* synthetic */ String val$field;
            final /* synthetic */ Supplier val$retentionQuerySupplier;
            {
                this.val$toWrap = oneMerge;
                this.val$field = string;
                this.val$retentionQuerySupplier = supplier;
                super(segments);
            }

            @Override
            public CodecReader wrapForMerge(CodecReader reader) throws IOException {
                CodecReader wrapped = this.val$toWrap.wrapForMerge(reader);
                Bits liveDocs = reader.getLiveDocs();
                if (liveDocs == null) {
                    return wrapped;
                }
                return SoftDeletesRetentionMergePolicy.applyRetentionQuery(this.val$field, (Query)this.val$retentionQuerySupplier.get(), wrapped);
            }
        });
        Objects.requireNonNull(field, "field must not be null");
        Objects.requireNonNull(retentionQuerySupplier, "retentionQuerySupplier must not be null");
        this.field = field;
        this.retentionQuerySupplier = retentionQuerySupplier;
    }

    @Override
    public boolean keepFullyDeletedSegment(IOSupplier<CodecReader> readerIOSupplier) throws IOException {
        CodecReader reader = readerIOSupplier.get();
        Scorer scorer = SoftDeletesRetentionMergePolicy.getScorer(this.retentionQuerySupplier.get(), FilterCodecReader.wrapLiveDocs(reader, null, reader.maxDoc()));
        if (scorer != null) {
            DocIdSetIterator iterator2 = scorer.iterator();
            boolean atLeastOneHit = iterator2.nextDoc() != Integer.MAX_VALUE;
            return atLeastOneHit;
        }
        return super.keepFullyDeletedSegment(readerIOSupplier);
    }

    static CodecReader applyRetentionQuery(String softDeleteField, Query retentionQuery, CodecReader reader) throws IOException {
        final Bits liveDocs = reader.getLiveDocs();
        if (liveDocs == null) {
            return reader;
        }
        FilterCodecReader wrappedReader = FilterCodecReader.wrapLiveDocs(reader, new Bits(){

            @Override
            public boolean get(int index) {
                return !liveDocs.get(index);
            }

            @Override
            public int length() {
                return liveDocs.length();
            }
        }, reader.maxDoc() - reader.numDocs());
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        builder.add(new FieldExistsQuery(softDeleteField), BooleanClause.Occur.FILTER);
        builder.add(retentionQuery, BooleanClause.Occur.FILTER);
        Scorer scorer = SoftDeletesRetentionMergePolicy.getScorer(builder.build(), wrappedReader);
        if (scorer != null) {
            FixedBitSet cloneLiveDocs = FixedBitSet.copyOf(liveDocs);
            DocIdSetIterator iterator2 = scorer.iterator();
            int numExtraLiveDocs = 0;
            while (iterator2.nextDoc() != Integer.MAX_VALUE) {
                if (cloneLiveDocs.getAndSet(iterator2.docID())) continue;
                ++numExtraLiveDocs;
            }
            assert (reader.numDocs() + numExtraLiveDocs <= reader.maxDoc()) : "numDocs: " + reader.numDocs() + " numExtraLiveDocs: " + numExtraLiveDocs + " maxDoc: " + reader.maxDoc();
            return FilterCodecReader.wrapLiveDocs(reader, cloneLiveDocs, reader.numDocs() + numExtraLiveDocs);
        }
        return reader;
    }

    private static Scorer getScorer(Query query, CodecReader reader) throws IOException {
        IndexSearcher s2 = new IndexSearcher(reader);
        s2.setQueryCache(null);
        Weight weight = s2.createWeight(s2.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        return weight.scorer(reader.getContext());
    }

    @Override
    public int numDeletesToMerge(SegmentCommitInfo info, int delCount, IOSupplier<CodecReader> readerSupplier) throws IOException {
        CodecReader reader;
        int numDeletesToMerge = super.numDeletesToMerge(info, delCount, readerSupplier);
        if (numDeletesToMerge != 0 && info.getSoftDelCount() > 0 && (reader = readerSupplier.get()).getLiveDocs() != null) {
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            builder.add(new FieldExistsQuery(this.field), BooleanClause.Occur.FILTER);
            builder.add(this.retentionQuerySupplier.get(), BooleanClause.Occur.FILTER);
            Scorer scorer = SoftDeletesRetentionMergePolicy.getScorer(builder.build(), FilterCodecReader.wrapLiveDocs(reader, null, reader.maxDoc()));
            if (scorer != null) {
                DocIdSetIterator iterator2 = scorer.iterator();
                Bits liveDocs = reader.getLiveDocs();
                int numDeletedDocs = reader.numDeletedDocs();
                while (iterator2.nextDoc() != Integer.MAX_VALUE) {
                    if (liveDocs.get(iterator2.docID())) continue;
                    --numDeletedDocs;
                }
                return numDeletedDocs;
            }
        }
        assert (numDeletesToMerge >= 0) : "numDeletesToMerge: " + numDeletesToMerge;
        assert (numDeletesToMerge <= info.info.maxDoc()) : "numDeletesToMerge: " + numDeletesToMerge + " maxDoc:" + info.info.maxDoc();
        return numDeletesToMerge;
    }
}

