/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource;

import com.dataiku.dss.shadelib.org.apache.lucene.index.LeafReaderContext;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.FunctionValues;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.ValueSource;
import com.dataiku.dss.shadelib.org.apache.lucene.queries.function.valuesource.MultiFunction;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public abstract class VectorSimilarityFunction
extends ValueSource {
    protected final com.dataiku.dss.shadelib.org.apache.lucene.index.VectorSimilarityFunction similarityFunction;
    protected final ValueSource vector1;
    protected final ValueSource vector2;

    public VectorSimilarityFunction(com.dataiku.dss.shadelib.org.apache.lucene.index.VectorSimilarityFunction similarityFunction, ValueSource vector1, ValueSource vector2) {
        this.similarityFunction = similarityFunction;
        this.vector1 = vector1;
        this.vector2 = vector2;
    }

    @Override
    public FunctionValues getValues(Map<Object, Object> context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vector1Vals = this.vector1.getValues(context, readerContext);
        final FunctionValues vector2Vals = this.vector2.getValues(context, readerContext);
        return new FunctionValues(){

            @Override
            public float floatVal(int doc) throws IOException {
                return VectorSimilarityFunction.this.func(doc, vector1Vals, vector2Vals);
            }

            @Override
            public String strVal(int doc) throws IOException {
                return Float.toString(this.floatVal(doc));
            }

            @Override
            public boolean exists(int doc) throws IOException {
                return MultiFunction.allExists(doc, vector1Vals, vector2Vals);
            }

            @Override
            public String toString(int doc) throws IOException {
                return VectorSimilarityFunction.this.description() + " = " + this.strVal(doc);
            }
        };
    }

    protected abstract float func(int var1, FunctionValues var2, FunctionValues var3) throws IOException;

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return Objects.equals(this.vector1, ((VectorSimilarityFunction)o).vector1) && Objects.equals(this.vector2, ((VectorSimilarityFunction)o).vector2);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.similarityFunction, this.vector1, this.vector2});
    }

    @Override
    public String description() {
        return this.similarityFunction.name() + "(" + this.vector1.description() + ", " + this.vector2.description() + ")";
    }
}

