/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.annotations;

import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.ListenerHolder;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.servlet.Source;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.DiscoveredAnnotation;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.MetaData;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.Origin;
import com.dataiku.dss.shadelib.org.eclipse.jetty.ee10.webapp.WebAppContext;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import jakarta.servlet.ServletContextAttributeListener;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.ServletRequestAttributeListener;
import jakarta.servlet.ServletRequestListener;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionIdListener;
import jakarta.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebListenerAnnotation
extends DiscoveredAnnotation {
    private static final Logger LOG = LoggerFactory.getLogger(WebListenerAnnotation.class);

    public WebListenerAnnotation(WebAppContext context, String className) {
        super(context, className);
    }

    public WebListenerAnnotation(WebAppContext context, String className, Resource resource) {
        super(context, className, resource);
    }

    @Override
    public void apply() {
        Class<?> clazz = this.getTargetClass();
        if (clazz == null) {
            LOG.warn("{} cannot be loaded", (Object)this._className);
            return;
        }
        try {
            if (ServletContextListener.class.isAssignableFrom(clazz) || ServletContextAttributeListener.class.isAssignableFrom(clazz) || ServletRequestListener.class.isAssignableFrom(clazz) || ServletRequestAttributeListener.class.isAssignableFrom(clazz) || HttpSessionListener.class.isAssignableFrom(clazz) || HttpSessionAttributeListener.class.isAssignableFrom(clazz) || HttpSessionIdListener.class.isAssignableFrom(clazz)) {
                MetaData metaData = this._context.getMetaData();
                if (metaData.getOrigin(clazz.getName() + ".listener") == Origin.NotSet) {
                    ListenerHolder h2 = this._context.getServletHandler().newListenerHolder(new Source(Source.Origin.ANNOTATION, clazz));
                    h2.setHeldClass(clazz);
                    this._context.getServletHandler().addListener(h2);
                    metaData.setOrigin(clazz.getName() + ".listener", clazz.getAnnotation(WebListener.class), clazz);
                }
            } else {
                LOG.warn("{} does not implement one of the servlet listener interfaces", (Object)clazz.getName());
            }
        }
        catch (Exception e) {
            LOG.warn("Unable to add listener {}", clazz, (Object)e);
        }
    }
}

