/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.io.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.io.ByteBufferAccumulator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.io.Content;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Promise;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.thread.Invocable;
import java.nio.ByteBuffer;

public class ContentSourceByteBuffer
implements Invocable.Task {
    private final ByteBufferAccumulator accumulator = new ByteBufferAccumulator();
    private final Content.Source source;
    private final Promise<ByteBuffer> promise;

    public ContentSourceByteBuffer(Content.Source source, Promise<ByteBuffer> promise) {
        this.source = source;
        this.promise = promise;
    }

    @Override
    public void run() {
        Content.Chunk chunk;
        do {
            if ((chunk = this.source.read()) == null) {
                this.source.demand(this);
                return;
            }
            if (Content.Chunk.isFailure(chunk)) {
                this.promise.failed(chunk.getFailure());
                if (!chunk.isLast()) {
                    this.source.fail(chunk.getFailure());
                }
                return;
            }
            this.accumulator.copyBuffer(chunk.getByteBuffer());
            chunk.release();
        } while (!chunk.isLast());
        this.promise.succeeded(this.accumulator.takeByteBuffer());
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return Invocable.getInvocationType(this.promise);
    }
}

