/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource;

import com.dataiku.dss.shadelib.org.eclipse.jetty.util.StringUtil;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.resource.Resource;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeNormalizer {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeNormalizer.class);
    private static final Pattern __propertyPattern = Pattern.compile("(?<=[^$]|^)\\$\\{([^}]*)\\}");
    private static final Comparator<Attribute> attrComparator = (o1, o2) -> {
        if (o1.value == null && o2.value != null) {
            return -1;
        }
        if (o1.value != null && o2.value == null) {
            return 1;
        }
        if (o1.value == null) {
            return 0;
        }
        int diff = o2.value.length() - o1.value.length();
        if (diff != 0) {
            return diff;
        }
        diff = o2.value.compareTo(o1.value);
        if (diff != 0) {
            return diff;
        }
        return o2.weight - o1.weight;
    };
    private final Resource baseResource;
    private final List<PathAttribute> paths = new ArrayList<PathAttribute>();
    private final List<URIAttribute> uris = new ArrayList<URIAttribute>();

    public static URI toCanonicalURI(URI uri) {
        String path = (uri = uri.normalize()).getPath();
        if (path != null && path.length() > 1 && path.endsWith("/")) {
            try {
                String ascii = uri.toASCIIString();
                uri = new URI(ascii.substring(0, ascii.length() - 1));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return uri;
    }

    public static String toCanonicalURI(String uri) {
        if (uri != null && uri.length() > 1 && uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }

    public static Path toCanonicalPath(String path) {
        if (path == null) {
            return null;
        }
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return AttributeNormalizer.toCanonicalPath(FileSystems.getDefault().getPath(path, new String[0]));
    }

    private static Path toCanonicalPath(Path path) {
        if (path == null) {
            return null;
        }
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return path.toRealPath(new LinkOption[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return path.toAbsolutePath();
    }

    public AttributeNormalizer(Resource baseResource) {
        if (baseResource == null) {
            throw new IllegalArgumentException("No base resource!");
        }
        this.baseResource = baseResource;
        this.addSystemProperty("jetty.base", 9);
        this.addSystemProperty("jetty.home", 8);
        this.addSystemProperty("user.home", 7);
        this.addSystemProperty("user.dir", 6);
        int weight = 9;
        for (Resource base : baseResource) {
            URI uri = base.getURI();
            if (uri == null) continue;
            URI warURI = AttributeNormalizer.toCanonicalURI(uri);
            if (!warURI.isAbsolute()) {
                throw new IllegalArgumentException("WAR URI is not absolute: " + String.valueOf(warURI));
            }
            Path path = base.getPath();
            if (path != null) {
                this.paths.add(new PathAttribute("WAR.path", AttributeNormalizer.toCanonicalPath(path), weight));
            }
            this.uris.add(new URIAttribute("WAR.uri", warURI, weight - 1));
            this.uris.add(new URIAttribute("WAR", warURI, weight - 2));
            weight += 3;
        }
        this.paths.sort(attrComparator);
        this.uris.sort(attrComparator);
        if (LOG.isDebugEnabled()) {
            Stream.concat(this.paths.stream(), this.uris.stream()).map(Object::toString).forEach(arg_0 -> ((Logger)LOG).debug(arg_0));
        }
    }

    private void addSystemProperty(String key, int weight) {
        String value = System.getProperty(key);
        if (value != null) {
            Path path = AttributeNormalizer.toCanonicalPath(value);
            this.paths.add(new PathAttribute(key, path, weight));
            this.uris.add(new URIAttribute(key + ".uri", path.toUri(), weight));
        }
    }

    public String normalize(Object o) {
        try {
            URI uri = null;
            Path path = null;
            if (o instanceof URI) {
                uri = AttributeNormalizer.toCanonicalURI((URI)o);
            } else if (o instanceof Resource) {
                uri = AttributeNormalizer.toCanonicalURI(((Resource)o).getURI());
            } else if (o instanceof URL) {
                uri = AttributeNormalizer.toCanonicalURI(((URL)o).toURI());
            } else if (o instanceof File) {
                path = ((File)o).getAbsoluteFile().getCanonicalFile().toPath();
            } else if (o instanceof Path) {
                path = (Path)o;
            } else {
                String s2 = o.toString();
                try {
                    uri = new URI(s2);
                    if (uri.getScheme() == null) {
                        return s2;
                    }
                }
                catch (URISyntaxException e) {
                    return s2;
                }
            }
            if (uri != null) {
                if ("jar".equalsIgnoreCase(uri.getScheme())) {
                    String raw = uri.getRawSchemeSpecificPart();
                    int bang = raw.indexOf("!/");
                    String normal = this.normalize(raw.substring(0, bang));
                    String suffix = raw.substring(bang);
                    return "jar:" + normal + suffix;
                }
                if (uri.isAbsolute()) {
                    return this.normalizeUri(uri);
                }
            } else if (path != null) {
                return this.normalizePath(path);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to normalize {}", o, (Object)e);
        }
        return String.valueOf(o);
    }

    protected String normalizeUri(URI uri) {
        for (URIAttribute a : this.uris) {
            String uPath;
            if (uri.compareTo(a.uri) == 0) {
                return String.format("${%s}", a.key);
            }
            if (!a.uri.getScheme().equalsIgnoreCase(uri.getScheme()) || a.uri.getHost() == null && uri.getHost() != null || a.uri.getHost() != null && !a.uri.getHost().equals(uri.getHost())) continue;
            String aPath = a.uri.getPath();
            if (aPath.equals(uPath = uri.getPath())) {
                return a.value;
            }
            if (!uPath.startsWith(aPath)) continue;
            if (uPath.length() == aPath.length()) {
                return String.format("${%s}", a.key);
            }
            String s2 = uPath.substring(aPath.length());
            if (s2.charAt(0) != '/') continue;
            return String.format("${%s}%s", a.key, s2);
        }
        return uri.toASCIIString();
    }

    protected String normalizePath(Path path) {
        for (PathAttribute a : this.paths) {
            try {
                if (path.equals(a.path) || Files.isSameFile(path, a.path)) {
                    return String.format("${%s}", a.key);
                }
            }
            catch (IOException x) {
                LOG.trace("IGNORED", (Throwable)x);
            }
            if (!path.startsWith(a.path)) continue;
            return String.format("${%s}%c%s", a.key, Character.valueOf(File.separatorChar), a.path.relativize(path));
        }
        return path.toString();
    }

    public String expand(String str) {
        if (str == null) {
            return str;
        }
        if (!str.contains("${")) {
            return str;
        }
        Matcher mat = __propertyPattern.matcher(str);
        if (mat.find(0)) {
            String prefix = str.substring(0, mat.start());
            String property = mat.group(1);
            String suffix = str.substring(mat.end());
            str = this.expand(prefix, property, suffix);
        }
        return StringUtil.replace(str, "$$", "$");
    }

    private String expand(String prefix, String property, String suffix) {
        if (property == null) {
            return null;
        }
        switch (property) {
            case "WAR": 
            case "WAR.path": {
                return prefix + String.valueOf(this.baseResource.resolve(suffix).getPath());
            }
            case "WAR.uri": {
                return prefix + String.valueOf(this.baseResource.resolve(suffix).getURI());
            }
        }
        for (URIAttribute attr : this.uris) {
            if (!property.equals(attr.key)) continue;
            return prefix + attr.value + suffix;
        }
        for (PathAttribute attr : this.paths) {
            if (!property.equals(attr.key)) continue;
            return prefix + attr.value + suffix;
        }
        String system = System.getProperty(property);
        if (system != null) {
            return prefix + system + suffix;
        }
        String unexpanded = prefix + "${" + property + "}" + suffix;
        LOG.warn("Cannot expand: {}", (Object)unexpanded);
        return unexpanded;
    }

    private static class PathAttribute
    extends Attribute {
        public final Path path;

        public PathAttribute(String key, Path path, int weight) {
            super(key, path.toString(), weight);
            this.path = path;
        }

        public String toString() {
            return String.format("PathAttribute[%s=>%s]", this.key, this.path);
        }
    }

    private static class URIAttribute
    extends Attribute {
        public final URI uri;

        public URIAttribute(String key, URI uri, int weight) {
            super(key, AttributeNormalizer.toCanonicalURI(uri.toASCIIString()), weight);
            this.uri = AttributeNormalizer.toCanonicalURI(uri);
        }

        public String toString() {
            return String.format("URIAttribute[%s=>%s]", this.key, this.uri);
        }
    }

    private static class Attribute {
        final String key;
        final String value;
        final int weight;

        public Attribute(String key, String value, int weight) {
            this.key = key;
            this.value = value;
            this.weight = weight;
        }
    }
}

