/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.internal;

import com.dataiku.dss.shadelib.org.eclipse.jetty.server.Context;
import com.dataiku.dss.shadelib.org.eclipse.jetty.util.Callback;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.Configuration;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.FrameHandler;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.FrameHandlerFactory;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.ServerUpgradeResponse;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketCreator;
import com.dataiku.dss.shadelib.org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;
import java.util.concurrent.atomic.AtomicReference;

public class CreatorNegotiator
extends WebSocketNegotiator.AbstractNegotiator {
    private final WebSocketCreator creator;
    private final FrameHandlerFactory factory;

    public CreatorNegotiator(WebSocketCreator creator, FrameHandlerFactory factory) {
        this(creator, factory, null);
    }

    public CreatorNegotiator(WebSocketCreator creator, FrameHandlerFactory factory, Configuration.Customizer customizer) {
        super(customizer);
        this.creator = creator;
        this.factory = factory;
    }

    public WebSocketCreator getWebSocketCreator() {
        return this.creator;
    }

    @Override
    public FrameHandler negotiate(ServerUpgradeRequest request, ServerUpgradeResponse response, Callback callback) {
        Object websocketPojo;
        Context context = request.getContext();
        try {
            AtomicReference result = new AtomicReference();
            context.run(() -> result.set(this.creator.createWebSocket(request, response, callback)));
            websocketPojo = result.get();
        }
        catch (Throwable t2) {
            callback.failed(t2);
            return null;
        }
        if (websocketPojo == null) {
            return null;
        }
        FrameHandler frameHandler = this.factory.newFrameHandler(websocketPojo, request, response);
        if (frameHandler == null) {
            callback.failed(new IllegalStateException("No WebSocket FrameHandler was created"));
        }
        return frameHandler;
    }

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.creator, this.factory);
    }
}

