/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelib.reactor.core.publisher;

import com.dataiku.dss.shadelib.reactor.core.CoreSubscriber;
import com.dataiku.dss.shadelib.reactor.core.Exceptions;
import com.dataiku.dss.shadelib.reactor.core.Fuseable;
import com.dataiku.dss.shadelib.reactor.core.Scannable;
import com.dataiku.dss.shadelib.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelib.reactor.core.publisher.Operators;
import com.dataiku.dss.shadelib.reactor.core.publisher.SourceProducer;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;

final class MonoErrorSupplied<T>
extends Mono<T>
implements Fuseable.ScalarCallable<T>,
SourceProducer<T> {
    final Supplier<? extends Throwable> errorSupplier;

    MonoErrorSupplied(Supplier<? extends Throwable> errorSupplier) {
        this.errorSupplier = Objects.requireNonNull(errorSupplier, "errorSupplier");
    }

    @Override
    public T block(Duration m4) {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        throw Exceptions.propagate(error);
    }

    @Override
    public T block() {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        throw Exceptions.propagate(error);
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        Operators.error(actual, error);
    }

    @Override
    public T call() throws Exception {
        Throwable error = Objects.requireNonNull(this.errorSupplier.get(), "the errorSupplier returned null");
        if (error instanceof Exception) {
            throw (Exception)error;
        }
        throw Exceptions.propagate(error);
    }

    @Override
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return null;
    }
}

