/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.io.ObjectStreamException;
import javax.measure.UnitConverter;
import tech.units.indriya.function.AbstractConverter;

class SexagesimalConverter
extends AbstractConverter {
    private static final long serialVersionUID = -2663951106460584999L;
    private static final double EPS = 1.0E-8;
    static final SexagesimalConverter INTEGER = new SexagesimalConverter(1);
    static final SexagesimalConverter FRACTIONAL = new SexagesimalConverter(10000);
    final int divider;
    private final SexagesimalConverter inverse;

    private SexagesimalConverter(int divider) {
        this.divider = divider;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(int divider, SexagesimalConverter inverse) {
        this.divider = divider;
        this.inverse = inverse;
    }

    public int compareTo(UnitConverter o) {
        return 0;
    }

    public final SexagesimalConverter inverseWhenNotIdentity() {
        return this.inverse;
    }

    protected boolean canReduceWith(AbstractConverter that) {
        return that instanceof Inverse;
    }

    public Number convertWhenNotIdentity(Number value) {
        return this.degreeToSexagesimalDegrees(value.doubleValue());
    }

    public double degreeToSexagesimalDegrees(double value) {
        int deg = (int)value;
        value = (value - (double)deg) * 60.0;
        int min = (int)value;
        value = (value - (double)min) * 60.0;
        int sec = (int)value;
        return ((double)((deg * 100 + min) * 100 + sec) + (value -= (double)sec)) / (double)this.divider;
    }

    public double sexagesimalDegreesToDegrees(double value) {
        int deg = (int)((value *= (double)this.divider) / 10000.0);
        int min = (int)((value -= (double)(10000 * deg)) / 100.0);
        value -= (double)(100 * min);
        if (min <= -60 || min >= 60) {
            if ((double)Math.abs(Math.abs(min) - 100) <= 1.0E-8) {
                deg = min >= 0 ? ++deg : --deg;
                min = 0;
            } else {
                throw new ArithmeticException("Invalid minutes: " + min);
            }
        }
        if (value <= -60.0 || value >= 60.0) {
            if (Math.abs(Math.abs(value) - 100.0) <= 1.0E-8) {
                min = value >= 0.0 ? ++min : --min;
                value = 0.0;
            } else {
                throw new ArithmeticException("Invalid secondes: " + value);
            }
        }
        value = (value / 60.0 + (double)min) / 60.0 + (double)deg;
        return value;
    }

    public final double derivative(double x) {
        return 1.0;
    }

    public boolean isIdentity() {
        return false;
    }

    public final boolean isLinear() {
        return false;
    }

    public final boolean equals(Object object) {
        return object != null && object.getClass().equals(((Object)((Object)this)).getClass()) && ((SexagesimalConverter)((Object)object)).divider == this.divider;
    }

    public int hashCode() {
        return 946369497 + this.divider;
    }

    protected String transformationLiteral() {
        return null;
    }

    protected Object readResolve() throws ObjectStreamException {
        SexagesimalConverter candidate = INTEGER;
        for (int i = 0; i <= 3; ++i) {
            switch (i) {
                case 0: {
                    break;
                }
                case 2: {
                    candidate = FRACTIONAL;
                    break;
                }
                default: {
                    candidate = candidate.inverse();
                }
            }
            if (!this.equals((Object)candidate)) continue;
            return candidate;
        }
        return this;
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -7145237719599612406L;

        public Inverse(SexagesimalConverter inverse) {
            super(inverse.divider, inverse);
        }

        @Override
        protected boolean canReduceWith(AbstractConverter that) {
            if (that instanceof Inverse) {
                return false;
            }
            return that instanceof SexagesimalConverter;
        }

        @Override
        public Number convertWhenNotIdentity(Number value) {
            return this.sexagesimalDegreesToDegrees(value.doubleValue());
        }

        @Override
        public int hashCode() {
            return -1349845494 + this.divider;
        }
    }
}

