/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.tree;

import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.tree.AbstractImmutableNodeHandler;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.tree.ImmutableNode;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.tree.NodeTracker;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.tree.ReferenceNodeHandler;
import com.dataiku.dss.shadelibdatabricks.org.apache.commons.configuration2.tree.ReferenceTracker;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class TreeData
extends AbstractImmutableNodeHandler
implements ReferenceNodeHandler {
    private final ImmutableNode root;
    private final Map<ImmutableNode, ImmutableNode> parentMapping;
    private final Map<ImmutableNode, ImmutableNode> replacementMapping;
    private final Map<ImmutableNode, ImmutableNode> inverseReplacementMapping;
    private final NodeTracker nodeTracker;
    private final ReferenceTracker referenceTracker;

    private static ImmutableNode handleReplacements(ImmutableNode replace, Map<ImmutableNode, ImmutableNode> mapping) {
        ImmutableNode org;
        ImmutableNode node = replace;
        do {
            if ((org = mapping.get(node)) == null) continue;
            node = org;
        } while (org != null);
        return node;
    }

    public TreeData(ImmutableNode root, Map<ImmutableNode, ImmutableNode> parentMapping, Map<ImmutableNode, ImmutableNode> replacements, NodeTracker tracker, ReferenceTracker refTracker) {
        this.root = root;
        this.parentMapping = parentMapping;
        this.replacementMapping = replacements;
        this.inverseReplacementMapping = this.createInverseMapping(replacements);
        this.nodeTracker = tracker;
        this.referenceTracker = refTracker;
    }

    public Map<ImmutableNode, ImmutableNode> copyParentMapping() {
        return new HashMap<ImmutableNode, ImmutableNode>(this.parentMapping);
    }

    public Map<ImmutableNode, ImmutableNode> copyReplacementMapping() {
        return new HashMap<ImmutableNode, ImmutableNode>(this.replacementMapping);
    }

    private Map<ImmutableNode, ImmutableNode> createInverseMapping(Map<ImmutableNode, ImmutableNode> replacements) {
        return replacements.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public NodeTracker getNodeTracker() {
        return this.nodeTracker;
    }

    @Override
    public ImmutableNode getParent(ImmutableNode node) {
        if (node == this.getRootNode()) {
            return null;
        }
        ImmutableNode org = TreeData.handleReplacements(node, this.inverseReplacementMapping);
        ImmutableNode parent = this.parentMapping.get(org);
        if (parent == null) {
            throw new IllegalArgumentException("Cannot determine parent! " + node + " is not part of this model.");
        }
        return TreeData.handleReplacements(parent, this.replacementMapping);
    }

    @Override
    public Object getReference(ImmutableNode node) {
        return this.getReferenceTracker().getReference(node);
    }

    public ReferenceTracker getReferenceTracker() {
        return this.referenceTracker;
    }

    @Override
    public ImmutableNode getRootNode() {
        return this.root;
    }

    @Override
    public List<Object> removedReferences() {
        return this.getReferenceTracker().getRemovedReferences();
    }

    public TreeData updateNodeTracker(NodeTracker newTracker) {
        return new TreeData(this.root, this.parentMapping, this.replacementMapping, newTracker, this.referenceTracker);
    }

    public TreeData updateReferenceTracker(ReferenceTracker newTracker) {
        return new TreeData(this.root, this.parentMapping, this.replacementMapping, this.nodeTracker, newTracker);
    }
}

