(function(){
    'use strict';

    const buildStepAddItemsModal = {
        bindings : {
            canDataset : '=',
            canManagedFolder : '=',
            canSavedModel : '=',
            canModelEvaluationStore : '=',
            canRetrievableKnowledge : '=',
            canFlowZone: '='
        },
        templateUrl : "static/dataiku/shared/components/scenario-add-items-modal/scenario-add-items-modal.component.html",
    }

    function addItemsModalController($scope, DataikuAPI, $stateParams, $filter, $http, $templateCache){
        $scope.displaySelection = 'NONE';
        $scope.newPartition = [];
        $scope.isAllFlowDatasets = false;

        $http.get('templates/scenarios/build_flowitem-new-dataset-modal.html').then(function(response) {
            $templateCache.put('datasetHTML', response.data);
            $scope.displaySelection = "DATASET";
        });

        $http.get('templates/scenarios/build_flowitem-new-managedfolder-modal.html').then(function(response) {
            $templateCache.put('managedFolderHTML', response.data);
        });

        $http.get('templates/scenarios/build_flowitem-new-savedmodel-modal.html').then(function(response) {
            $templateCache.put('savedModelHTML', response.data);
        });

        $http.get('templates/scenarios/build_flowitem-new-modelevaluationstore-modal.html').then(function(response) {
            $templateCache.put('modelEvaluationStoreHTML', response.data);
        });

        $http.get('templates/scenarios/build_flowitem-new-retrievableknowledge-modal.html').then(function(response) {
            $templateCache.put('retrievableKnowledgeHTML', response.data);
        });

        $http.get('templates/scenarios/build_flowitem-new-flowzone-modal.html').then(function(response) {
            $templateCache.put('flowZoneHTML', response.data);
        });

        $scope.setDisplaySelection = function(itemType) {
            $scope.displaySelection = itemType;

            $scope.flowItemPartitioning = undefined;
            if(itemType === 'DATASET' && $scope.newDataset){
                $scope.flowItemPartitioning = $scope.partitioning[$scope.getDatasetLoc($scope.newDataset)];
            }else if(itemType === 'MANAGED_FOLDER' && $scope.newManagedFolder){
                $scope.flowItemPartitioning = $scope.partitioning[$scope.getManagedFolderLoc($scope.newManagedFolder)];
            }else if(itemType === 'SAVED_MODEL' && $scope.newSavedModel){
                $scope.flowItemPartitioning = $scope.partitioning[$scope.getSavedModelLoc($scope.newSavedModel)];
            }else if(itemType === 'MODEL_EVALUATION_STORE' && $scope.newModelEvaluationStore){
                $scope.flowItemPartitioning = $scope.partitioning[$scope.getModelEvaluationStoreLoc($scope.newModelEvaluationStore)];
            }
        }

        $scope.addDatasetToList = function(){
            let idx = - 1;
            for(let i = 0; i < $scope.items.length; i++){
                if($scope.getItemLoc($scope.items[i]) == $scope.getDatasetLoc($scope.newDataset)
                    && $scope.items[i].partition == $scope.newPartition){
                    idx = i;
                }
            }
            if(idx == -1){
                $scope.items.push({
                    type:"DATASET",
                    projectKey: $scope.getProjectKeyIfNeeded($scope.newDataset.projectKey),
                    itemId: $scope.newDataset.name,
                    partitionsSpec: $scope.newPartition.join('|')
                });
            }
            $scope.dismiss();
        };

        $scope.addManagedFolderToList = function() {
            var idx = - 1;
            for(var i = 0; i < $scope.items.length; i++){
                if($scope.getItemLoc($scope.items[i]) == $scope.getManagedFolderLoc($scope.newManagedFolder) && $scope.items[i].partition == $scope.newPartition){
                    idx = i;
                }
            }
            if(idx == -1){
                $scope.items.push({
                    type:"MANAGED_FOLDER",
                    projectKey: $scope.getProjectKeyIfNeeded($scope.newManagedFolder.projectKey),
                    itemId: $scope.newManagedFolder.id,
                    partitionsSpec: $scope.newPartition.join('|')
                });
            }
            $scope.dismiss();
        };

        $scope.addSavedModelToList = function(){
            var idx = - 1;
            for(var i = 0; i < $scope.items.length; i++){
                if($scope.getItemLoc($scope.items[i]) == $scope.getSavedModelLoc($scope.newSavedModel)){
                    idx = i;
                }
            }
            if(idx == -1){
                $scope.items.push({
                    type:"SAVED_MODEL",
                    projectKey: $scope.getProjectKeyIfNeeded($scope.newSavedModel.projectKey),
                    itemId: $scope.newSavedModel.id,
                    partitionsSpec: $scope.newPartition.join('|')
                });
            }
            $scope.dismiss();
        };

        $scope.addEvaluationStoreToList = function(){
            var idx = - 1;
            for(var i = 0; i < $scope.items.length; i++){
                if($scope.getItemLoc($scope.items[i]) == $scope.getModelEvaluationStoreLoc($scope.newModelEvaluationStore)){
                    idx = i;
                }
            }
            if(idx == -1){
                $scope.items.push({
                    type:"MODEL_EVALUATION_STORE",
                    projectKey: $scope.getProjectKeyIfNeeded($scope.newModelEvaluationStore.projectKey),
                    itemId: $scope.newModelEvaluationStore.id,
                    partitionsSpec: $scope.newPartition.join('|')
                });
            }
            $scope.dismiss();
        };

        $scope.addRetrievableKnowledgeToList = function() {
            const alreadyListedRK = $scope.items.some(item => $scope.getItemLoc(item) === $scope.getRetrievableKnowledgeLoc($scope.newRetrievableKnowledge));

            if (!alreadyListedRK) {
                $scope.items.push({
                    type:"RETRIEVABLE_KNOWLEDGE",
                    projectKey: $scope.getProjectKeyIfNeeded($scope.newRetrievableKnowledge.projectKey),
                    itemId: $scope.newRetrievableKnowledge.id,
                });
            }

            $scope.dismiss();
        };

        $scope.addFlowZoneContentToList = function() {
            angular.forEach($scope.computables, function(computable) {
                let userDefinedPartitioning = Object.values(computable.buildPartitions).join("|");
                let alreadyListed;

                if (computable.removed) {
                    return;
                }

                switch(computable.type){
                    case "DATASET":
                        alreadyListed = $scope.items.some(item => $scope.getItemLoc(item) === $scope.getDatasetLoc(computable) && item.partitionsSpec === userDefinedPartitioning);
                        if(!alreadyListed){
                            $scope.items.push({
                                type:"DATASET",
                                projectKey: $scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),
                                itemId: computable.name,
                                partitionsSpec: userDefinedPartitioning
                            });
                        }
                        $scope.dismiss();
                        break;
                    case "MANAGED_FOLDER":
                        alreadyListed = $scope.items.some(item => $scope.getItemLoc(item) === $scope.getManagedFolderLoc(computable) && item.partitionsSpec === userDefinedPartitioning);
                        if(!alreadyListed){
                            $scope.items.push({
                                type:"MANAGED_FOLDER",
                                projectKey: $scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),
                                itemId: computable.id,
                                partitionsSpec: userDefinedPartitioning
                            });
                        }
                        $scope.dismiss();
                        break;
                    case "SAVED_MODEL":
                        alreadyListed = $scope.items.some(item => $scope.getItemLoc(item) === $scope.getSavedModelLoc(computable));
                        if(!alreadyListed){
                            $scope.items.push({
                                type:"SAVED_MODEL",
                                projectKey: $scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),
                                itemId: computable.id,
                                partitionsSpec: userDefinedPartitioning
                            });
                        }
                        $scope.dismiss();
                        break;
                    case "MODEL_EVALUATION_STORE":
                        alreadyListed = $scope.items.some(item => $scope.getItemLoc(item) === $scope.getModelEvaluationStoreLoc(computable));
                        if(!alreadyListed){
                            $scope.items.push({
                                type:"MODEL_EVALUATION_STORE",
                                projectKey: $scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),
                                itemId: computable.id,
                                partitionsSpec: userDefinedPartitioning
                            });
                        }
                        $scope.dismiss();
                        break;
                    case "RETRIEVABLE_KNOWLEDGE":
                        alreadyListed = $scope.items.some(item => $scope.getItemLoc(item) === $scope.getRetrievableKnowledgeLoc(computable));
                        if (!alreadyListed) {
                            $scope.items.push({
                                type:"RETRIEVABLE_KNOWLEDGE",
                                projectKey: $scope.getProjectKeyIfNeeded($scope.newFlowZone.projectKey),
                                itemId: computable.id,
                            });
                        }
                        $scope.dismiss();
                        break;
                }
            });
        };

        $scope.setDataset = function(selectedDataset){
            $scope.newDataset = selectedDataset;
        }

        $scope.setManagedFolder = function(selectedManagedFolder){
            $scope.newManagedFolder = selectedManagedFolder;
        }

        $scope.setSavedModel = function(selectedSavedModel){
            $scope.newSavedModel = selectedSavedModel;
        }

        $scope.setEvaluationStore = function(selectedEvaluationStore){
            $scope.newModelEvaluationStore = selectedEvaluationStore;
        }

        $scope.updateComputables = function(selectedFlowZone) {
            $scope.newFlowZone = selectedFlowZone;
            DataikuAPI.flow.listDownstreamComputables($stateParams.projectKey, { zoneId: $scope.newFlowZone.id })
                .success((result) => {
                    $scope.computables = result;
                    $scope.isAllFlowDatasets = result.length > 0 && result.filter(computable => computable.type === 'DATASET').length === result.length;
                })
                .error(setErrorInScope.bind($scope));
        }

        $scope.setRetrievableKnowledge = function(selectedRetrievableKnowledge){
            $scope.newRetrievableKnowledge = selectedRetrievableKnowledge;
        }

        $scope.$watch('newDataset', function() {
            $scope.flowItemPartitioning = $scope.partitioning[$scope.getDatasetLoc($scope.newDataset)];
        });

        $scope.$watch('newManagedFolder', function() {
            $scope.flowItemPartitioning = $scope.partitioning[$scope.getManagedFolderLoc($scope.newManagedFolder)];
        });

        $scope.$watch('newSavedModel', function() {
            $scope.flowItemPartitioning = $scope.partitioning[$scope.getSavedModelLoc($scope.newSavedModel)];
        });

        $scope.$watch('newModelEvaluationStore', function() {
            $scope.flowItemPartitioning = $scope.partitioning[$scope.getModelEvaluationStoreLoc($scope.newModelEvaluationStore)];
        });

        $scope.addToList = function() {
            switch ($scope.displaySelection){
                case "DATASET":
                    $scope.addDatasetToList();
                    break;

                case "MANAGED_FOLDER":
                    $scope.addManagedFolderToList();
                    break;

                case "SAVED_MODEL":
                    $scope.addSavedModelToList();
                    break;

                case "MODEL_EVALUATION_STORE":
                    $scope.addEvaluationStoreToList();
                    break;

                case "RETRIEVABLE_KNOWLEDGE":
                    $scope.addRetrievableKnowledgeToList();
                    break;

                case "FLOW_ZONE":
                    $scope.addFlowZoneContentToList();
                    break;
            }
        }

        $scope.getPartitioning = function(computable) {
            if (computable.type === 'DATASET') {
                return computable.serializedDataset.partitioning;
            }
            if (computable.type === 'MANAGED_FOLDER') {
                return computable.box.partitioning;
            }
            if (computable.type === 'SAVED_MODEL') {
                return computable.model.partitioning;
            }
        };

        $scope.getIcon = function(computable) {
            switch(computable.type) {
                case 'DATASET':                 return 'dataset ' + $filter('toModernIcon')($filter('datasetTypeToIcon')(computable.serializedDataset.type, 16), 16);
                case 'MANAGED_FOLDER':          return 'dku-icon-dataset-files-in-folder-16';
                case 'SAVED_MODEL':             return 'dku-icon-machine-learning-regression-16';
                case 'RETRIEVABLE_KNOWLEDGE':   return 'retrievable-knowledge dku-icon-cards-stack-16';
                case 'MODEL_EVALUATION_STORE':  return 'dku-icon-model-evaluation-store-16';
            }
        };

        $scope.removeRestore = function(index, isRemove) {
            $scope.computables[index].removed = isRemove;
            $scope.validateForm();
        };

        $scope.validateForm = function() {
            $scope.theform.$invalid = $scope.computables.find(i => !i.removed) == undefined;
        };
    }

    angular.module('dataiku.shared').component('buildStepAddItemsModal', buildStepAddItemsModal)
        .controller("BuildStepAddItemsModalController", addItemsModalController);
})();