import os
import logging
import requests

def get_internal_api_key():
    with open('%s/run/shared-secret.txt' % os.getenv("DKU_LAMBDA_HOME"), 'r') as fp:
        secret = fp.read()
        secret = secret.strip()

    port = int(os.environ["DKU_APIMAIN_PORT"])

    logging.getLogger("admin").info("Getting the internal API key for CLI client")

    http_res = requests.request("GET",
                                "http://127.0.0.1:%s/admin/api/pintercom/internal-api-key/get-temporary-admin-key" % port,
                                headers={
                                    "X-DKU-IPythonSharedSecret": secret,
                                })
    http_res.raise_for_status()

    return http_res.json()["key"]
