import sys

import numpy as np
import pandas as pd
import six

from dataiku.base.utils import package_is_at_least


def typed_series_from_array(data, dtype):
    if dtype == 'str' and sys.version_info < (3, 0):
        data = [(x.encode('utf8') if isinstance(x, six.text_type) else x) for x in data]
    #Work around https://github.com/pandas-dev/pandas/issues/44923
    if package_is_at_least(pd, "1.3") and not package_is_at_least(pd, "1.6") and dtype == np.int64:
        return pd.Series(np.array(data, dtype=dtype))
    else:
        return pd.Series(data, dtype=dtype)
