from typing import Optional
from dataiku.eda.types import Literal

import numpy as np

from dataiku.eda.computations.immutable_data_frame import ImmutableDataFrame
from dataiku.eda.filtering.filter import Filter
from dataiku.eda.types import AllFilterModel


class AllFilter(Filter):
    def __init__(self, name: Optional[str] = None):
        self.name = name

    @staticmethod
    def get_type() -> Literal["all"]:
        return "all"

    @staticmethod
    def build(params: AllFilterModel) -> 'AllFilter':
        return AllFilter()

    def apply(self, idf: ImmutableDataFrame, inverse: bool = False) -> ImmutableDataFrame:
        if inverse:
            return idf[[]]
        else:
            return idf[np.arange(len(idf))]

    def serialize(self) -> AllFilterModel:
        return {"type": self.get_type(), "name": self.name}
