class Blueprint: 
    def __init__(self, json):
        """
        Instantiate a new Govern Blueprint.

        :param str json: A Python dict containing the blueprint data.
            This class is actually mostly a wrapper around that json dict.
        """
        self.json = json

    @property
    def id(self):
        """
        Return the artifact id.

        :return: the artifact id as a Python str
        """
        if 'id' not in self.json:
            raise Exception("id not set for blueprint {name}".format(name=self.name))
        return self.json.get('id')

    @property
    def name(self):
        """
        Return the blueprint name.

        :return: the blueprint name as a Python str
        """
        return self.json.get('name')

    @property
    def icon(self):
        """
        Return the blueprint icon.

        :return: the blueprint icon as a Python str
        """
        return self.json.get('icon')

    @property
    def color(self):
        """
        Return the blueprint color.

        :return: the blueprint color as a Python str
        """
        return self.json.get('color')

    @property
    def backgroundColor(self):
        """
        Return the blueprint background color.

        :return: the blueprint background color as a Python str
        """
        return self.json.get('backgroundColor')
