CREATE TABLE artifact_governance_settings (
    artifact_governance_settings_artifact_id TEXT PRIMARY KEY GENERATED ALWAYS AS ((artifact_governance_settings_json ->> 'artifactId')::TEXT) STORED,
    artifact_governance_settings_json JSONB NOT NULL,
    CONSTRAINT artifact_governance_settings__ar_id_fkey FOREIGN KEY (artifact_governance_settings_artifact_id) REFERENCES artifacts(artifact_id)
);

CREATE TABLE artifact_governance_settings_history (
    artifact_governance_settings_artifact_id TEXT GENERATED ALWAYS AS ((artifact_governance_settings_json ->> 'artifactId')::TEXT) STORED NOT NULL,
    artifact_governance_settings_json JSONB NOT NULL,
    PRIMARY KEY (_revision_id)
) INHERITS (_history_revisions);
CREATE INDEX artifact_governance_settings_history_ar_id_index ON artifact_governance_settings_history (artifact_governance_settings_artifact_id);
