/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.auth;

import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonServiceException;
import com.dataiku.dss.legacy.aws.com.amazonaws.AmazonWebServiceRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.ClientConfiguration;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSSessionCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.AnonymousAWSCredentials;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.RefreshableTask;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.SessionCredentialsHolder;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.ShouldDoAsyncSessionRefresh;
import com.dataiku.dss.legacy.aws.com.amazonaws.auth.ShouldDoBlockingSessionRefresh;
import com.dataiku.dss.legacy.aws.com.amazonaws.retry.PredefinedBackoffStrategies;
import com.dataiku.dss.legacy.aws.com.amazonaws.retry.RetryPolicy;
import com.dataiku.dss.legacy.aws.com.amazonaws.retry.RetryUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.securitytoken.model.AssumeRoleWithWebIdentityResult;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.securitytoken.model.IDPCommunicationErrorException;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.securitytoken.model.InvalidIdentityTokenException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;

public class STSAssumeRoleWithWebIdentitySessionCredentialsProvider
implements AWSSessionCredentialsProvider,
Closeable {
    private static final String PROVIDER_NAME = "StsAssumeRoleWithWebIdentityCredentialsProvider";
    private final AWSSecurityTokenService securityTokenService;
    private final String roleArn;
    private final String roleSessionName;
    private final String webIdentityTokenFile;
    private final Callable<SessionCredentialsHolder> refreshCallable = new Callable<SessionCredentialsHolder>(){

        @Override
        public SessionCredentialsHolder call() throws Exception {
            return STSAssumeRoleWithWebIdentitySessionCredentialsProvider.this.newSession();
        }
    };
    private volatile RefreshableTask<SessionCredentialsHolder> refreshableTask;

    private RefreshableTask<SessionCredentialsHolder> createRefreshableTask() {
        return new RefreshableTask.Builder<SessionCredentialsHolder>().withRefreshCallable(this.refreshCallable).withBlockingRefreshPredicate(new ShouldDoBlockingSessionRefresh()).withAsyncRefreshPredicate(new ShouldDoAsyncSessionRefresh()).build();
    }

    private STSAssumeRoleWithWebIdentitySessionCredentialsProvider(Builder builder) {
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.webIdentityTokenFile = builder.webIdentityTokenFile;
        this.securityTokenService = STSAssumeRoleWithWebIdentitySessionCredentialsProvider.buildStsClient(builder);
        this.refreshableTask = this.createRefreshableTask();
    }

    private static AWSSecurityTokenService buildStsClient(Builder builder) throws IllegalArgumentException {
        if (builder.sts != null) {
            return builder.sts;
        }
        RetryPolicy retryPolicy = new RetryPolicy(new StsRetryCondition(), new PredefinedBackoffStrategies.SDKDefaultBackoffStrategy(), 3, true);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setRetryPolicy(retryPolicy);
        AnonymousAWSCredentials credentials = new AnonymousAWSCredentials(PROVIDER_NAME);
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withClientConfiguration(clientConfiguration)).withCredentials(new AWSStaticCredentialsProvider(credentials))).build();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        return this.refreshableTask.getValue().getSessionCredentials();
    }

    @Override
    public void refresh() {
        this.refreshableTask.forceGetValue();
    }

    private SessionCredentialsHolder newSession() {
        AssumeRoleWithWebIdentityRequest assumeRoleRequest = new AssumeRoleWithWebIdentityRequest().withRoleArn(this.roleArn).withWebIdentityToken(this.getWebIdentityToken()).withRoleSessionName(this.roleSessionName);
        AssumeRoleWithWebIdentityResult assumeRoleResult = this.securityTokenService.assumeRoleWithWebIdentity(assumeRoleRequest);
        return new SessionCredentialsHolder(assumeRoleResult.getCredentials(), PROVIDER_NAME);
    }

    private String getWebIdentityToken() {
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.webIdentityTokenFile), "UTF-8"));
            String string = br.readLine();
            return string;
        }
        catch (FileNotFoundException e) {
            throw new SdkClientException("Unable to locate specified web identity token file: " + this.webIdentityTokenFile);
        }
        catch (IOException e) {
            throw new SdkClientException("Unable to read web identity token from file: " + this.webIdentityTokenFile);
        }
        finally {
            try {
                br.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void close() {
        this.refreshableTask.close();
    }

    static class StsRetryCondition
    implements RetryPolicy.RetryCondition {
        StsRetryCondition() {
        }

        @Override
        public boolean shouldRetry(AmazonWebServiceRequest originalRequest, AmazonClientException exception, int retriesAttempted) {
            if (exception.getCause() instanceof IOException) {
                return true;
            }
            if (exception instanceof InvalidIdentityTokenException || exception.getCause() instanceof InvalidIdentityTokenException) {
                return true;
            }
            if (exception instanceof IDPCommunicationErrorException || exception.getCause() instanceof IDPCommunicationErrorException) {
                return true;
            }
            if (exception instanceof AmazonServiceException) {
                AmazonServiceException ase = (AmazonServiceException)exception;
                if (RetryUtils.isRetryableServiceException(ase)) {
                    return true;
                }
                if (RetryUtils.isThrottlingException(ase)) {
                    return true;
                }
                if (RetryUtils.isClockSkewError(ase)) {
                    return true;
                }
            }
            return false;
        }
    }

    public static final class Builder {
        private final String roleArn;
        private final String roleSessionName;
        private final String webIdentityTokenFile;
        private AWSSecurityTokenService sts;

        public Builder(String roleArn, String roleSessionName, String webIdentityTokenFile) {
            if (roleArn == null || roleSessionName == null || webIdentityTokenFile == null) {
                throw new NullPointerException("You must specify a value for roleArn, roleSessionName and webIdentityTokenFile");
            }
            this.roleArn = roleArn;
            this.roleSessionName = roleSessionName;
            this.webIdentityTokenFile = webIdentityTokenFile;
        }

        public Builder withStsClient(AWSSecurityTokenService sts) {
            this.sts = sts;
            return this;
        }

        public STSAssumeRoleWithWebIdentitySessionCredentialsProvider build() {
            return new STSAssumeRoleWithWebIdentitySessionCredentialsProvider(this);
        }
    }
}

